/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.hdc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ui.UIUtil;
import com.mindspore.ide.toolkit.hdc.ErrorDataInfo;
import com.mindspore.ide.toolkit.hdc.HdcRegularUtils;
import com.mindspore.ide.toolkit.hdc.msjtable.GridBagTable;
import com.mindspore.ide.toolkit.hdc.msjtable.TableViewRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class ErrorDialog
extends JDialog {
    private ErrorDataInfo errorDataInfo;
    private Project project;
    private JButton copyJLabel;
    private GridBagTable jTable;
    private String[][] objects;

    public ErrorDialog(ErrorDataInfo errorDataInfo, Project project) {
        this.errorDataInfo = errorDataInfo;
        this.project = project;
        this.setTitle("Trouble shooting");
        this.setModal(true);
        int dialogHeight = 135 + errorDataInfo.getStrings().size() * 30;
        this.setSize(1040, dialogHeight);
        this.setLocationRelativeTo(null);
        this.initJLabel();
        int tableHeight = errorDataInfo.getStrings().size() * 30 + 35;
        this.initJTable(tableHeight);
        this.buttonListener();
        this.setLayout(null);
    }

    private void initJLabel() {
        JLabel firstLinePromptJLabel = new JLabel(this.errorDataInfo.getTitleString(), 0);
        firstLinePromptJLabel.setBounds(new Rectangle(0, 10, 1040, 30));
        firstLinePromptJLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 16));
        if (UIUtil.isUnderDarcula()) {
            firstLinePromptJLabel.setForeground(Color.WHITE);
        } else {
            firstLinePromptJLabel.setForeground(Color.BLACK);
        }
        this.add(firstLinePromptJLabel);
        this.copyJLabel = new JButton("\u590d\u5236\u9519\u8bef\u62a5\u544a Copy FAR");
        this.copyJLabel.setBounds(new Rectangle(800, 5, 213, 40));
        this.copyJLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 16));
        if (UIUtil.isUnderDarcula()) {
            this.copyJLabel.setForeground(Color.WHITE);
        } else {
            this.copyJLabel.setForeground(Color.BLACK);
        }
        this.add(this.copyJLabel);
    }

    private void initJTable(int height) {
        this.objects = (String[][])this.errorDataInfo.getStrings().toArray((T[])new String[0][]);
        Object[] titles = new String[]{this.errorDataInfo.getProjectString(), this.errorDataInfo.getDescriptionString()};
        DefaultTableModel defaultTableModel = new DefaultTableModel(this.objects, titles);
        this.jTable = new GridBagTable(defaultTableModel);
        if (UIUtil.isUnderDarcula()) {
            this.jTable.getTableHeader().setForeground(Color.WHITE);
        } else {
            this.jTable.getTableHeader().setForeground(Color.BLACK);
        }
        this.jTable.getTableHeader().setBounds(new Rectangle(0, 0, 1000, 30));
        this.jTable.getTableHeader().setPreferredSize(new Dimension(1000, 30));
        this.jTable.getTableHeader().setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 16));
        this.jTable.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 16));
        this.jTable.setRowHeight(30);
        TableViewRenderer tableViewRenderer = new TableViewRenderer();
        this.jTable.setDefaultRenderer(Object.class, tableViewRenderer);
        for (int[] ints : this.errorDataInfo.getIntMerge()) {
            this.jTable.mergeCells(ints[0], ints[1], ints[2], ints[3]);
        }
        this.jTable.setEnabled(false);
        this.jTable.setBounds(new Rectangle(13, 50, 1000, height));
        this.jTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.jTable.getColumnModel().getColumn(1).setPreferredWidth(850);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 16));
        renderer.setBounds(new Rectangle(0, 0, 1000, 30));
        renderer.setHorizontalAlignment(0);
        if (UIUtil.isUnderDarcula()) {
            renderer.setForeground(Color.WHITE);
        } else {
            renderer.setForeground(Color.BLACK);
        }
        this.jTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
        JScrollPane scrollPane = new JScrollPane(this.jTable);
        scrollPane.setBounds(new Rectangle(13, 50, 1000, height));
        this.add((Component)scrollPane, "Center");
    }

    private void buttonListener() {
        this.copyJLabel.addActionListener(e -> {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection trans = new StringSelection(this.errorDataInfo.getErrorString());
            clipboard.setContents(trans, null);
            Messages.showMessageDialog((Project)this.project, (String)"\u5df2\u7ecf\u590d\u5236\u9519\u8bef\u62a5\u544a\u5230\u526a\u5207\u677f", (String)"\u63d0\u793a", (Icon)Messages.getInformationIcon());
        });
        this.jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int col;
                JTable jTable1;
                int raw;
                String strHttp;
                if (mouseEvent.getSource() instanceof JTable && !(strHttp = HdcRegularUtils.filterSpecialStr("((http|ftp|https)://)(([a-zA-Z0-9\\._-]+\\.[a-zA-Z]{2,6})|([0-9]{1,3}\\.[0-9]{1,3}))(:[0-9]{1,4})*(/[a-zA-Z0-9\\&%_\\./-~-]*)?", ErrorDialog.this.objects[raw = (jTable1 = (JTable)mouseEvent.getSource()).rowAtPoint(mouseEvent.getPoint())][col = jTable1.columnAtPoint(mouseEvent.getPoint())])).isEmpty()) {
                    try {
                        Desktop.getDesktop().browse(new URI(strHttp));
                    }
                    catch (IOException | URISyntaxException ex) {
                        ex.toString();
                    }
                }
            }
        });
    }
}

