/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.search;

import com.intellij.util.io.HttpRequests;
import com.mindspore.ide.toolkit.search.MsVersionDataConfig;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdDataGet {
    private static final String NEW_LINE = "\n";
    private static final Logger LOG = LoggerFactory.getLogger(MdDataGet.class);
    private String mdVersion = "";
    public String pytorchMdStr = "";
    public String tensorflowMdStr = "";

    public MdDataGet(MsVersionDataConfig.MsVersionData msVersionData) {
        this.mdVersion = msVersionData.getMdVersion();
        this.pytorchMdStr = this.getPytorchMdStr(msVersionData.getPytorchMdUrl());
        this.tensorflowMdStr = this.getTensorflowMdStr(msVersionData.getTensorflowMdUrl());
    }

    public String getPytorchMdStr(String url) {
        return this.getMdData(url, 3000);
    }

    public String getTensorflowMdStr(String url) {
        return this.getMdData(url, 3000);
    }

    private String getMdData(String url, int timeout) {
        String mdData;
        try {
            mdData = HttpRequests.request((String)url).connectTimeout(timeout).readString();
        }
        catch (IOException ioException) {
            mdData = "";
            LOG.warn("get md data failed: {}", (Object)ioException.toString());
        }
        return mdData;
    }
}

