/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.apiscanning;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.Vector;

public class VirtualFileNode {
    public VirtualFile virtualFile;
    public VirtualFileNode parent = null;
    public Vector<VirtualFileNode> children = new Vector();
    public boolean markedPy = false;

    public VirtualFileNode(VirtualFile virtualFile) {
        this.virtualFile = virtualFile;
    }

    public void insert(VirtualFileNode newChild, int childIndex) {
        if (newChild == null) {
            throw new IllegalArgumentException("new child is null");
        }
        VirtualFileNode oldParent = newChild.getParent();
        if (oldParent != null) {
            oldParent.remove(newChild);
        }
        newChild.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(newChild, childIndex);
    }

    public void remove(VirtualFileNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        this.remove(this.getIndex(aChild));
    }

    public void remove(int childIndex) {
        VirtualFileNode child = this.getChildAt(childIndex);
        this.children.removeElementAt(childIndex);
    }

    public VirtualFileNode getChildAt(int index) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        return this.children.elementAt(index);
    }

    public int getIndex(VirtualFileNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        return this.children.indexOf(aChild);
    }

    public void add(VirtualFileNode newChild) {
        if (newChild != null) {
            this.insert(newChild, this.getChildCount());
        }
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public String toString() {
        return this.virtualFile.getName();
    }

    public VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    public void setVirtualFile(VirtualFile virtualFile) {
        this.virtualFile = virtualFile;
    }

    public VirtualFileNode getParent() {
        return this.parent;
    }

    public void setParent(VirtualFileNode parent) {
        this.parent = parent;
    }

    public Vector<VirtualFileNode> getChildren() {
        return this.children;
    }

    public void setChildren(Vector<VirtualFileNode> children) {
        this.children = children;
    }

    public boolean isMarkedPy() {
        return this.markedPy;
    }

    public void setMarkedPy(boolean markedPy) {
        this.markedPy = markedPy;
    }
}

