/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.smartcomplete;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.util.SystemInfo;
import com.mindspore.ide.toolkit.common.ResourceManager;
import com.mindspore.ide.toolkit.common.events.EventCenter;
import com.mindspore.ide.toolkit.common.events.SmartCompleteEvents;
import com.mindspore.ide.toolkit.common.utils.FileUtils;
import com.mindspore.ide.toolkit.common.utils.NotificationUtils;
import com.mindspore.ide.toolkit.smartcomplete.CompleteConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelFile {
    private static final Logger log = LoggerFactory.getLogger(ModelFile.class);
    private final CompleteConfig completeConfig = CompleteConfig.get();
    private final CompleteConfig.Model currentModel = this.completeConfig.getCurrentModel();
    private final int queueCapacity = 100;
    private final ThreadPoolExecutor modelFileExecutor = new ThreadPoolExecutor(2 * Runtime.getRuntime().availableProcessors(), 4 * Runtime.getRuntime().availableProcessors(), 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100), new ThreadPoolExecutor.CallerRunsPolicy());

    public boolean modelExeExists() {
        String modelExeFullPath = this.completeConfig.getModelExeFullPath(this.currentModel);
        return FileUtils.getFile(modelExeFullPath).exists();
    }

    public boolean fetchModelFile() {
        String modelDownloadUrl = this.currentModel.getModelDownloadUrl();
        String modelZipFullPath = this.completeConfig.getModelZipFullPath(this.currentModel);
        String accessToken = this.currentModel.getAccessToken();
        int maxDownloadTimes = 3;
        EventCenter.INSTANCE.publish(new SmartCompleteEvents.DownloadCompleteModelStart());
        boolean isDownloadSucceed = false;
        for (int i = 0; i < maxDownloadTimes && !(isDownloadSucceed = ResourceManager.downloadResource(modelDownloadUrl, modelZipFullPath, accessToken, 300000)); ++i) {
        }
        if (isDownloadSucceed) {
            String modelZipParentPath;
            String unzipFileLocation = modelZipParentPath = this.completeConfig.getModelZipParentPath(this.currentModel);
            if (this.completeConfig.isExtranet()) {
                unzipFileLocation = this.completeConfig.getModelUnzipFolderFullPath(this.currentModel);
            }
            EventCenter.INSTANCE.publish(new SmartCompleteEvents.DownloadCompleteModelEnd());
            ResourceManager.unzipResource(modelZipFullPath, unzipFileLocation);
            this.setFolderPermission(modelZipParentPath);
            this.deleteNoUseZipFile(modelZipParentPath);
        } else if (SystemInfo.isWindows || SystemInfo.isLinux) {
            NotificationUtils.notify(NotificationUtils.NotifyGroup.SMART_COMPLETE, NotificationType.ERROR, "Download complete model failed.");
        }
        log.info("Smart complete model download result:{}", (Object)isDownloadSucceed);
        return isDownloadSucceed;
    }

    public void deleteInvalidModelAsync() {
        this.modelFileExecutor.execute(() -> {
            String modelFolderPath = this.completeConfig.getModelFolderPath();
            try {
                Set<String> pluginVersionSet = FileUtils.listAllDirectory(Paths.get(modelFolderPath, new String[0]));
                for (String pluginVersion : pluginVersionSet) {
                    this.deleteInvalidModel(pluginVersion, modelFolderPath);
                }
            }
            catch (IOException ioException) {
                log.warn("Delete invalid model failed.", (Throwable)ioException);
            }
        });
    }

    public void shutdownExecutor() {
        this.modelFileExecutor.shutdown();
    }

    private void deleteInvalidModel(String pluginVersion, String modelFolderPath) throws IOException {
        if (Objects.equals(this.currentModel.getPluginVersion(), pluginVersion)) {
            this.deleteInvalidModelWhenPluginVersionIsSame(pluginVersion);
        } else {
            FileUtils.deleteFile(new File(String.join((CharSequence)File.separator, modelFolderPath, pluginVersion)));
        }
    }

    private void deleteInvalidModelWhenPluginVersionIsSame(String pluginVersion) throws IOException {
        String pluginVersionPath = this.completeConfig.getPluginVersionFolderPath(pluginVersion);
        Set<String> modelVersionSet = FileUtils.listAllDirectory(Paths.get(pluginVersionPath, new String[0]));
        for (String modelVersion : modelVersionSet) {
            if (Objects.equals(this.currentModel.getModelVersion(), modelVersion)) continue;
            FileUtils.deleteFile(new File(String.join((CharSequence)File.separator, pluginVersionPath, modelVersion)));
        }
    }

    private void setFolderPermission(String modelZipParentPath) {
        if (SystemInfo.isLinux) {
            ProcessBuilder builder = new ProcessBuilder("/bin/chmod", "-R", "777", modelZipParentPath);
            try {
                builder.start().waitFor();
            }
            catch (IOException | InterruptedException exception) {
                log.warn("Change folder \"{}\" permission failed.", (Object)modelZipParentPath, (Object)exception);
            }
        }
    }

    private void deleteNoUseZipFile(String folderPath) {
        Set<Object> fileNameSet = Collections.emptySet();
        try {
            fileNameSet = FileUtils.listAllFile(Paths.get(folderPath, new String[0]));
        }
        catch (IOException ioException) {
            log.warn("List model zip file failed.", (Throwable)ioException);
        }
        for (String string : fileNameSet) {
            if (!string.endsWith(".zip")) continue;
            FileUtils.deleteFile(new File(String.join((CharSequence)File.separator, folderPath, string)));
        }
    }
}

