/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingChannelBuilder;
import io.grpc.Status;
import io.grpc.alts.CallCredentialsInterceptor;
import io.grpc.alts.CheckGcpEnvironment;
import io.grpc.alts.HandshakerServiceChannel;
import io.grpc.alts.internal.AltsProtocolNegotiator;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourcePool;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.util.List;
import javax.net.ssl.SSLException;

public final class ComputeEngineChannelBuilder
extends ForwardingChannelBuilder<ComputeEngineChannelBuilder> {
    private final NettyChannelBuilder delegate;

    private ComputeEngineChannelBuilder(String target) {
        SslContext sslContext;
        this.delegate = NettyChannelBuilder.forTarget((String)target);
        try {
            sslContext = GrpcSslContexts.forClient().build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        InternalNettyChannelBuilder.setProtocolNegotiatorFactory((NettyChannelBuilder)this.delegate(), (InternalNettyChannelBuilder.ProtocolNegotiatorFactory)new AltsProtocolNegotiator.GoogleDefaultProtocolNegotiatorFactory((List<String>)ImmutableList.of(), (ObjectPool<Channel>)SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL), sslContext));
        CallCredentials credentials = MoreCallCredentials.from((Credentials)ComputeEngineCredentials.create());
        Status status = Status.OK;
        if (!CheckGcpEnvironment.isOnGcp()) {
            status = Status.INTERNAL.withDescription("Compute Engine Credentials can only be used on Google Cloud Platform");
        }
        this.delegate().intercept(new ClientInterceptor[]{new CallCredentialsInterceptor(credentials, status)});
    }

    public static final ComputeEngineChannelBuilder forTarget(String target) {
        return new ComputeEngineChannelBuilder(target);
    }

    public static ComputeEngineChannelBuilder forAddress(String name, int port) {
        return ComputeEngineChannelBuilder.forTarget(GrpcUtil.authorityFromHostAndPort((String)name, (int)port));
    }

    protected NettyChannelBuilder delegate() {
        return this.delegate;
    }

    @VisibleForTesting
    InternalProtocolNegotiator.ProtocolNegotiator getProtocolNegotiatorForTest() {
        SslContext sslContext;
        try {
            sslContext = GrpcSslContexts.forClient().build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        return new AltsProtocolNegotiator.GoogleDefaultProtocolNegotiatorFactory((List<String>)ImmutableList.of(), (ObjectPool<Channel>)SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL), sslContext).buildProtocolNegotiator();
    }
}

