/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.search;

import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.mindspore.ide.toolkit.common.config.GlobalConfig;
import com.mindspore.ide.toolkit.common.events.EventCenter;
import com.mindspore.ide.toolkit.common.events.SearchSelectMindSpore;
import com.mindspore.ide.toolkit.common.utils.IdeUtils;
import com.mindspore.ide.toolkit.search.MSElementsRenderer;
import com.mindspore.ide.toolkit.search.OperatorSearchService;
import com.mindspore.ide.toolkit.search.entity.DocumentSearch;
import com.mindspore.ide.toolkit.search.entity.DocumentValue;
import com.mindspore.ide.toolkit.search.entity.OpenMindSporeActionModel;
import com.mindspore.ide.toolkit.search.entity.OperatorRecord;
import com.mindspore.ide.toolkit.ui.search.BrowserWindowManager;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MindSporeSearchEverywhereContributor
implements SearchEverywhereContributor<DocumentSearch> {
    private final Project mindSporeProject;
    private final WeakReference<Component> mindSporeContextComponent;

    public MindSporeSearchEverywhereContributor(Project mindSporeProject, Component mindSporeContextComponent) {
        this.mindSporeProject = mindSporeProject;
        this.mindSporeContextComponent = new WeakReference<Component>(mindSporeContextComponent);
    }

    public int getSortWeight() {
        return 600;
    }

    public boolean isShownInSeparateTab() {
        return true;
    }

    @NotNull
    public String getSearchProviderId() {
        String string = this.getClass().getSimpleName();
        if (string == null) {
            MindSporeSearchEverywhereContributor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getGroupName() {
        String string = GlobalConfig.get().getToolWindowName();
        if (string == null) {
            MindSporeSearchEverywhereContributor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public ListCellRenderer<? super DocumentSearch> getElementsRenderer() {
        return new MSElementsRenderer();
    }

    @Nullable
    public Object getDataForItem(@NotNull DocumentSearch element, @NotNull String dataId) {
        if (element == null) {
            MindSporeSearchEverywhereContributor.$$$reportNull$$$0(2);
        }
        if (dataId == null) {
            MindSporeSearchEverywhereContributor.$$$reportNull$$$0(3);
        }
        return null;
    }

    public boolean showInFindResults() {
        return false;
    }

    public void fetchElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super DocumentSearch> consumer) {
        AnAction anAction;
        if (pattern == null) {
            MindSporeSearchEverywhereContributor.$$$reportNull$$$0(4);
        }
        if (progressIndicator == null) {
            MindSporeSearchEverywhereContributor.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            MindSporeSearchEverywhereContributor.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmptyOrSpaces((String)pattern)) {
            return;
        }
        if (progressIndicator.isCanceled()) {
            return;
        }
        List<OperatorRecord> model = OperatorSearchService.INSTANCE.search(pattern, 10);
        if (model != null) {
            for (OperatorRecord entry : model) {
                DocumentSearch search = new DocumentSearch(entry, pattern);
                if (consumer.process((Object)search)) continue;
                return;
            }
        }
        if ((anAction = ActionManager.getInstance().getAction("ActivateMindSporeToolWindow")) != null) {
            anAction.getTemplatePresentation().setText("Search On MindSpore...");
            DocumentSearch searchDoc = new DocumentSearch(anAction, pattern, 1);
            consumer.process((Object)searchDoc);
        }
    }

    public boolean processSelectedItem(@NotNull DocumentSearch selected, int modifiers, @NotNull String searchText) {
        if (selected == null) {
            MindSporeSearchEverywhereContributor.$$$reportNull$$$0(7);
        }
        if (searchText == null) {
            MindSporeSearchEverywhereContributor.$$$reportNull$$$0(8);
        }
        boolean selectedMark = false;
        if (selected.getValue() instanceof AnAction) {
            SearchSelectMindSpore searchSelectMindSpore = new SearchSelectMindSpore();
            searchSelectMindSpore.setData("selected.getValue() instanceof AnAction");
            EventCenter.INSTANCE.publish(searchSelectMindSpore);
            BrowserWindowManager.getBrowserWindow(this.mindSporeProject).loadUrl(GlobalConfig.get().getToolWindowUrl());
            selectedMark = true;
        } else if (selected.getValue() instanceof Map.Entry) {
            Map.Entry map = (Map.Entry)selected.getValue();
            SearchSelectMindSpore searchSelectMindSpore = new SearchSelectMindSpore();
            searchSelectMindSpore.setData((String)map.getValue());
            EventCenter.INSTANCE.publish(searchSelectMindSpore);
            BrowserWindowManager.getBrowserWindow(this.mindSporeProject).loadUrl((String)map.getValue());
            selectedMark = true;
        } else if (selected.getValue() instanceof OperatorRecord) {
            OperatorRecord map = (OperatorRecord)selected.getValue();
            SearchSelectMindSpore searchSelectMindSpore = new SearchSelectMindSpore();
            searchSelectMindSpore.setData(map.getMindSporeOperator());
            EventCenter.INSTANCE.publish(searchSelectMindSpore);
            BrowserWindowManager.getBrowserWindow(this.mindSporeProject).loadUrl(map.getMindSporeLink());
            selectedMark = true;
        } else if (selected.getValue() instanceof DocumentValue) {
            DocumentValue documentValue = (DocumentValue)selected.getValue();
            EventCenter.INSTANCE.publish(new OpenMindSporeActionModel(this.mindSporeProject, documentValue));
            selectedMark = true;
        }
        if (selectedMark) {
            IdeUtils.showToolWindowById(this.mindSporeProject, "MindSpore");
        }
        return selectedMark;
    }

    @NotNull
    private static SearchEverywhereContributor<DocumentSearch> mindSporeCreate(@NotNull AnActionEvent initEvent) {
        if (initEvent == null) {
            MindSporeSearchEverywhereContributor.$$$reportNull$$$0(9);
        }
        return new MindSporeSearchEverywhereContributor(initEvent.getProject(), (Component)initEvent.getData(PlatformDataKeys.CONTEXT_COMPONENT));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/mindspore/ide/toolkit/search/MindSporeSearchEverywhereContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchProviderId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/mindspore/ide/toolkit/search/MindSporeSearchEverywhereContributor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDataForItem";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fetchElements";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processSelectedItem";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mindSporeCreate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<DocumentSearch> {
        @NotNull
        public SearchEverywhereContributor<DocumentSearch> createContributor(@NotNull AnActionEvent initEvent) {
            if (initEvent == null) {
                Factory.$$$reportNull$$$0(0);
            }
            SearchEverywhereContributor<DocumentSearch> searchEverywhereContributor = MindSporeSearchEverywhereContributor.mindSporeCreate(initEvent);
            if (searchEverywhereContributor == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return searchEverywhereContributor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initEvent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/mindspore/ide/toolkit/search/MindSporeSearchEverywhereContributor$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/mindspore/ide/toolkit/search/MindSporeSearchEverywhereContributor$Factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createContributor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createContributor";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

