/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.apiscanning;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.mindspore.ide.toolkit.common.utils.FileUtils;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;

public class ExportDialog
extends JDialog {
    TextFieldWithBrowseButton pathBrowseButton;
    JButton exportButton;
    private String apiString;
    private String fileName;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");

    public ExportDialog(String apiString, String fileName) {
        this.apiString = apiString;
        this.setTitle("\u5bfc\u51fa\u8868\u683c\u5185\u5bb9");
        this.setModal(true);
        this.setSize(600, 100);
        this.fileName = fileName;
        this.setLocationRelativeTo(null);
        this.initDialog();
        this.setLayout(null);
    }

    private void initDialog() {
        this.pathBrowseButton = new TextFieldWithBrowseButton();
        this.pathBrowseButton.setBounds(50, 10, 350, 30);
        this.pathBrowseButton.setText(SystemProperties.getUserHome() + File.separator + this.fileName + "-mapping-" + this.dateFormat.format(new Date()) + ".csv");
        this.add((Component)this.pathBrowseButton);
        this.pathBrowseButton.addBrowseFolderListener(new TextBrowseFolderListener(new FileChooserDescriptor(false, true, false, false, false, false)){

            @NlsSafe
            protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                String dir = chosenFile.getPresentableUrl();
                String text = ExportDialog.this.pathBrowseButton.getText();
                String fileNameTemp = text.substring(text.lastIndexOf(File.separator) + 1);
                return dir + File.separator + fileNameTemp;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/mindspore/ide/toolkit/apiscanning/ExportDialog$1", "chosenFileToResultingText"));
            }
        });
        this.exportButton = new JButton();
        this.exportButton.setBounds(450, 10, 100, 35);
        this.exportButton.setText("\u5bfc\u51fa");
        this.add(this.exportButton);
        this.exportButton.addActionListener(actionEvent -> {
            String filePath = this.pathBrowseButton.getText();
            try (ByteArrayInputStream is = new ByteArrayInputStream(this.apiString.getBytes("GB2312"));){
                FileUtils.writeFile(filePath, is);
                JOptionPane.showMessageDialog(null, "\u5bfc\u51fa\u6210\u529f\uff0c\u6587\u4ef6\u8def\u5f84\uff1a" + filePath);
                this.setVisible(false);
            }
            catch (IOException ioException) {
                JOptionPane.showMessageDialog(null, "\u5bfc\u51fa\u5931\u8d25");
            }
        });
    }
}

