/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.apiscanning.utils;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.mindspore.ide.toolkit.search.entity.LinkInfo;
import com.mindspore.ide.toolkit.ui.search.BrowserWindowManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JTable;

public class ApiMappingUiUtil {
    private static final String NEW_LINE = "\n";
    private static final String API = "\u53ef\u4ee5\u8f6c\u6362\u4e3aMindSpore API\u7684PyTorch/TensorFlow API";
    private static final String API_NULL = "\u6682\u65f6\u4e0d\u80fd\u8f6c\u6362\u7684API";
    private static final String PAPI = "\u53ef\u80fd\u662fPyTorch/TensorFlow API\u7684\u60c5\u51b5";

    public static void buttonListener(JButton export, ActionListener actionListener) {
        export.addActionListener(actionListener);
    }

    public static StringBuilder initData(Object[][] api, Object[][] apiNull, Object[][] papi) {
        StringBuilder str = new StringBuilder();
        str.append(API).append(",").append(NEW_LINE);
        ApiMappingUiUtil.append(str, api);
        if (apiNull.length > 0) {
            str.append(",").append(NEW_LINE).append(API_NULL).append(",").append(NEW_LINE);
            ApiMappingUiUtil.append(str, apiNull);
        }
        if (papi.length > 0) {
            str.append(",").append(NEW_LINE).append(PAPI).append(",").append(NEW_LINE);
            ApiMappingUiUtil.append(str, papi);
        }
        return str;
    }

    public static void append(StringBuilder builder, Object[][] table) {
        if (table == null) {
            return;
        }
        Object[][] objectArray = table;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object[] objects;
            for (Object object : objects = objectArray[i]) {
                if (object instanceof LinkInfo) {
                    LinkInfo linkInfo = (LinkInfo)object;
                    String text = String.format("\"=HYPERLINK(\"\"%s\"\",\"\"%s\"\")\"", linkInfo.getUrl(), linkInfo.getText() + linkInfo.getVersionString());
                    builder.append(text.trim()).append(",");
                    continue;
                }
                builder.append(object == null ? "" : object.toString().trim()).append(",");
            }
            builder.setLength(builder.length() - 1);
            builder.append(NEW_LINE);
        }
    }

    public static MouseAdapter createListener(final Object[][] data, final JTable table, final Project project) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int column;
                if (e.getButton() != 1 || e.getClickCount() != 1) {
                    return;
                }
                int row = table.rowAtPoint(e.getPoint());
                Object o = data[row][column = table.columnAtPoint(e.getPoint())];
                if (o instanceof LinkInfo) {
                    LinkInfo linkModel = (LinkInfo)o;
                    BrowserWindowManager.getBrowserWindow(project).loadUrl(linkModel.getUrl());
                    ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
                    ToolWindow toolWindow = toolWindowManager.getToolWindow("MindSpore");
                    toolWindow.show();
                }
            }
        };
    }
}

