/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.apiscanning;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.mindspore.ide.toolkit.apiscanning.ApiMappingUI;
import com.mindspore.ide.toolkit.common.events.CommonEvent;
import com.mindspore.ide.toolkit.common.events.EventCenter;
import com.mindspore.ide.toolkit.common.utils.MSPsiUtils;
import com.mindspore.ide.toolkit.common.utils.NotificationUtils;
import com.mindspore.ide.toolkit.common.utils.RegularUtils;
import com.mindspore.ide.toolkit.search.OperatorSearchService;
import com.mindspore.ide.toolkit.search.entity.LinkInfo;
import com.mindspore.ide.toolkit.search.entity.OperatorRecord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransApiAction
extends AnAction {
    private static final Logger log = LoggerFactory.getLogger(TransApiAction.class);
    private static final String NO_PACKAGE_PLACEHOLDER = "<no package>";
    private final Map<String, Content> contentMap = new HashMap<String, Content>();
    private Map<String, String> importMap = new LinkedHashMap<String, String>();
    private Map<String, String> fromMap;
    private Map<String, String> fromAsMap;
    private Set<String> apiNameList;
    private Set<String> apiBlurredNameList;

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            TransApiAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext = e.getDataContext();
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        this.importMap = new HashMap<String, String>();
        this.fromMap = new HashMap<String, String>();
        this.fromAsMap = new HashMap<String, String>();
        this.apiNameList = new LinkedHashSet<String>();
        this.apiBlurredNameList = new LinkedHashSet<String>();
        TransApiAction.translateImport((PsiElement)psiFile, this.importMap, this.fromMap, this.fromAsMap);
        this.translateCallExpression((PsiElement)psiFile);
        Set<String> apiNameFiltering = TransApiAction.filteringApi(this.apiNameList);
        Set<String> apiBlurredNameFiltering = TransApiAction.filteringApi(this.apiBlurredNameList);
        LinkedList<Object[]> apiNameNullList = new LinkedList<Object[]>();
        List<Object[]> straightApiMappingList = this.sortList(apiNameFiltering, apiNameNullList);
        List<Object[]> blurredApiMappingList = this.sortList(apiBlurredNameFiltering, null);
        if (straightApiMappingList.size() > 0) {
            Project project1 = e.getProject();
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project1);
            ToolWindow toolWindow = toolWindowManager.getToolWindow("MindSporeApiMapping");
            ContentManager contentManager = toolWindow.getContentManager();
            String name = psiFile.getName();
            JComponent jComponent = ApiMappingUI.build(TransApiAction.trans(straightApiMappingList), TransApiAction.trans(blurredApiMappingList), TransApiAction.trans(apiNameNullList), project1, name);
            Content content = ContentFactory.SERVICE.getInstance().createContent(jComponent, name, true);
            Content oldContent = this.contentMap.put(name, content);
            if (oldContent != null) {
                contentManager.removeContent(oldContent, true);
            }
            contentManager.addContent(content);
            contentManager.setSelectedContent(content, true, true);
            toolWindow.show();
        } else {
            NotificationUtils.notify(NotificationUtils.NotifyGroup.API_SCANNING, NotificationType.INFORMATION, "\u65e0\u76f8\u5173API");
        }
        EventCenter.INSTANCE.publish(new CommonEvent());
    }

    public static Set<String> filteringApi(Set<String> apiNameList) {
        LinkedHashSet<String> stringSet = new LinkedHashSet<String>();
        apiNameList.forEach(s -> {
            if (RegularUtils.isApi(s)) {
                stringSet.add((String)s);
            }
        });
        return stringSet;
    }

    public static Object[][] trans(List<Object[]> data) {
        if (CollectionUtils.isEmpty(data)) {
            return new Object[0][];
        }
        Object[][] objects = new Object[data.size()][data.get(0).length];
        for (int i = 0; i < data.size(); ++i) {
            objects[i] = data.get(i);
        }
        return objects;
    }

    private List<Object[]> sortList(Set<String> apiNameList, List<Object[]> apiNameNullList) {
        Set<String> apiString = TransApiAction.filteringData(apiNameList);
        this.importMapDataSort(apiString, apiNameList);
        this.fromMapDataSort(apiString, apiNameList);
        this.fromAsMapDataSort(apiString, apiNameList);
        return TransApiAction.searchData(TransApiAction.filteringData(apiString), apiNameNullList);
    }

    private void importMapDataSort(Set<String> apiString, Set<String> apiNameList) {
        this.importMap.forEach((key, value) -> {
            if (value == null) {
                TransApiAction.importMapDataSortIf(apiString, apiNameList, key);
            } else {
                TransApiAction.importMapDataSortElse(apiString, apiNameList, key, value);
            }
        });
    }

    public static void importMapDataSortIf(Set<String> apiString, Set<String> apiNameList, String key) {
        for (String str : apiNameList) {
            String[] split = str.split("\\.");
            if (split.length > 0) {
                if (!split[0].equals(key)) continue;
                apiString.add(str);
                continue;
            }
            if (!str.equals(key)) continue;
            apiString.add(str);
        }
    }

    public static void importMapDataSortElse(Set<String> apiString, Set<String> apiNameList, String key, String value) {
        for (String str : apiNameList) {
            String[] split = str.split("\\.");
            if (split.length > 0) {
                if (!split[0].equals(value)) continue;
                apiString.add(str.replaceFirst(value, key));
                continue;
            }
            if (!str.equals(value)) continue;
            apiString.add(str.replaceFirst(value, key));
        }
    }

    private void fromMapDataSort(Set<String> apiString, Set<String> apiNameList) {
        this.fromMap.forEach((key, value) -> {
            if (value == null) {
                for (String str : apiNameList) {
                    apiString.add(key + "." + str);
                }
            } else {
                TransApiAction.fromMapDataSortElse(apiString, apiNameList, key, value);
            }
        });
    }

    public static void fromMapDataSortElse(Set<String> apiString, Set<String> apiNameList, String key, String value) {
        for (String str : apiNameList) {
            String[] split = str.split("\\.");
            if (split.length > 0) {
                if (!split[0].equals(value)) continue;
                apiString.add(key + str.replaceFirst(split[0], ""));
                continue;
            }
            if (!str.equals(value)) continue;
            apiString.add(key);
        }
    }

    private void fromAsMapDataSort(Set<String> apiString, Set<String> apiNameList) {
        this.fromAsMap.forEach((key, value) -> {
            for (String str : apiNameList) {
                String[] split = str.split("\\.");
                if (split.length > 0) {
                    if (!split[0].equals(value)) continue;
                    apiString.add(key + str.replaceFirst(split[0], ""));
                    continue;
                }
                if (!str.equals(value)) continue;
                apiString.add((String)key);
            }
        });
    }

    public static Set<String> filteringData(Set<String> apiNameList) {
        LinkedHashSet<String> apiString = new LinkedHashSet<String>();
        Iterator<String> it = apiNameList.iterator();
        while (it.hasNext()) {
            String[] apiNew;
            String str = it.next();
            String[] api = str.split("\\.");
            if (api.length > 0 && "tensorflow".equals(api[0])) {
                str = str.replaceFirst("tensorflow", "tf");
            }
            if (!"tf".equals((apiNew = str.split("\\."))[0]) && !"torch".equals(apiNew[0]) && !"torchtext".equals(apiNew[0]) && !"torchvision".equals(apiNew[0])) continue;
            apiString.add(str);
            it.remove();
        }
        return apiString;
    }

    public static List<Object[]> searchData(Set<String> apiStringSet, List<Object[]> apiNameNullList) {
        LinkedList<Object[]> apiList = new LinkedList<Object[]>();
        LinkedList<Object[]> nonMatchApiList = new LinkedList<Object[]>();
        for (String str : apiStringSet) {
            String[] api = str.split("\\.");
            if (api.length > 0 && "tensorflow".equals(api[0])) {
                str = str.replaceFirst("tensorflow", "tf");
            }
            List<OperatorRecord> records = OperatorSearchService.INSTANCE.searchFullMatch(str);
            for (OperatorRecord record : records) {
                Object[] cells = new Object[]{Strings.isEmpty((String)record.getOriginalLink()) ? record.getOriginalLink() : new LinkInfo(record.getOriginalOperator(), record.getOriginalLink()), record.getVersionText(), Strings.isEmpty((String)record.getMindSporeLink()) ? record.getMindSporeOperator() : new LinkInfo(record.getMindSporeOperator(), record.getMindSporeLink()), Strings.isEmpty((String)record.getDescriptionLink()) ? record.getDescription() + (record.isInWhiteList() ? "" : "\uff08\u4ec5\u652f\u63012.0\u53ca\u4ee5\u4e0a\u7248\u672cMindSpore\uff09") : new LinkInfo(record.getDescription(), record.getDescriptionLink(), !record.isInWhiteList())};
                apiList.add(cells);
            }
            if (!records.isEmpty()) continue;
            nonMatchApiList.add(new Object[]{str, "", "", new LinkInfo("\u7f3a\u5931api\u5904\u7406\u7b56\u7565", "https://www.mindspore.cn/docs/zh-CN/master/migration_guide/analysis_and_preparation.html#%E7%BC%BA%E5%A4%B1api%E5%A4%84%E7%90%86%E7%AD%96%E7%95%A5")});
        }
        ((List)Objects.requireNonNullElse(apiNameNullList, apiList)).addAll(nonMatchApiList);
        return apiList;
    }

    private void translateCallExpressionInPyCallExpression(PsiElement psiElement, List<String[]> formerFunction) {
        for (PsiElement element : psiElement.getChildren()) {
            if (element instanceof PyCallExpression) {
                String value;
                String key;
                PyCallExpression pyCallExpression = (PyCallExpression)element;
                String apiString = pyCallExpression.getCallee().getText();
                int lastDot = apiString.lastIndexOf(46);
                if (lastDot > 0 && apiString.length() > lastDot) {
                    key = apiString.substring(0, lastDot);
                    value = apiString.substring(lastDot + 1);
                } else {
                    key = apiString;
                    value = NO_PACKAGE_PLACEHOLDER;
                }
                formerFunction.add(new String[]{key, value});
                this.translateCallExpressionInPyCallExpression(element, formerFunction);
                continue;
            }
            if (element instanceof PyReferenceExpression && element.getChildren().length > 0 && !element.getText().toLowerCase().equals(element.getText())) {
                this.apiNameList.add(element.getText());
                this.translateCallExpressionInPyCallExpression(element, formerFunction);
                continue;
            }
            this.translateCallExpressionInPyCallExpression(element, formerFunction);
        }
        if (formerFunction.size() <= 0) {
            log.info("The length of the formerFunction is 0");
        } else {
            int last = formerFunction.size() - 1;
            String lastKey = formerFunction.get(last)[0];
            formerFunction.forEach(record -> {
                if (record[0].equals(lastKey)) {
                    if (NO_PACKAGE_PLACEHOLDER.equals(record[1])) {
                        this.apiNameList.add(lastKey);
                    } else {
                        this.apiNameList.add(lastKey + "." + record[1]);
                    }
                } else if (NO_PACKAGE_PLACEHOLDER.equals(record[1])) {
                    this.apiBlurredNameList.add(lastKey);
                } else {
                    this.apiBlurredNameList.add(lastKey + "." + record[1]);
                }
            });
        }
        formerFunction.clear();
    }

    private void translateCallExpression(PsiElement psiElement) {
        ArrayList<String[]> formerFunction = new ArrayList<String[]>();
        for (PsiElement element : psiElement.getChildren()) {
            if (element instanceof PyCallExpression) {
                String value;
                String key;
                PyCallExpression pyCallExpression = (PyCallExpression)element;
                String apiString = pyCallExpression.getCallee().getText();
                int lastDot = apiString.lastIndexOf(46);
                if (lastDot > 0 && apiString.length() > lastDot) {
                    key = apiString.substring(0, lastDot);
                    value = apiString.substring(lastDot + 1);
                } else {
                    key = apiString;
                    value = NO_PACKAGE_PLACEHOLDER;
                }
                formerFunction.add(new String[]{key, value});
                this.translateCallExpressionInPyCallExpression(element, formerFunction);
                continue;
            }
            if (element instanceof PyReferenceExpression && !MSPsiUtils.isPsiImport(element) && element.getChildren().length > 0 && !element.getText().toLowerCase().equals(element.getText())) {
                this.apiNameList.add(element.getText());
                continue;
            }
            this.translateCallExpression(element);
        }
    }

    public static void translateImport(PsiElement psiElement, Map<String, String> importMap, Map<String, String> fromMap, Map<String, String> fromAsMap) {
        for (PsiElement element : psiElement.getChildren()) {
            try {
                if (element instanceof PyImportStatementBase) {
                    PyImportStatementBase importStatementBase = (PyImportStatementBase)element;
                    if (element instanceof PyImportStatement) {
                        PyImportElement importElement = importStatementBase.getImportElements()[0];
                        importMap.put(importElement.getImportedQName().toString(), importElement.getAsName());
                        continue;
                    }
                    if (element instanceof PyFromImportStatement) {
                        PyFromImportStatement pyFromImportStatement = (PyFromImportStatement)element;
                        if (pyFromImportStatement.getImportElements().length < 1) continue;
                        if (pyFromImportStatement.getImportElements()[0].getAsName() == null) {
                            for (PyImportElement pyImportElement : importStatementBase.getImportElements()) {
                                fromMap.put(pyFromImportStatement.getImportSourceQName().toString() + "." + pyImportElement.getText(), pyImportElement.getText());
                            }
                            continue;
                        }
                        fromAsMap.put((String)importStatementBase.getFullyQualifiedObjectNames().get(0), importStatementBase.getImportElements()[0].getAsName());
                        continue;
                    }
                    log.info("psiFile exceptions");
                    continue;
                }
                TransApiAction.translateImport(element, importMap, fromMap, fromAsMap);
            }
            catch (Throwable ex) {
                log.debug("import analyse error", ex);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/mindspore/ide/toolkit/apiscanning/TransApiAction", "actionPerformed"));
    }
}

