/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.search;

import com.mindspore.ide.toolkit.search.SearchEveryWhereDataHub;
import com.mindspore.ide.toolkit.search.entity.OperatorRecord;
import com.mindspore.ide.toolkit.search.structure.TrieNode;
import java.util.ArrayList;
import java.util.List;

public enum OperatorSearchService {
    INSTANCE;

    private TrieNode root = new TrieNode();
    private SearchEveryWhereDataHub<String, OperatorRecord> mdFile2Map = SearchEveryWhereDataHub.getOperatorDataHub();

    private OperatorSearchService() {
        this.mdFile2Map.searchable().forEach(this.root::addWord);
    }

    public List<OperatorRecord> search(String inputString) {
        return this.search(inputString, Integer.MAX_VALUE);
    }

    public List<OperatorRecord> search(String inputString, int count) {
        if (inputString == null || inputString.isEmpty()) {
            return new ArrayList<OperatorRecord>();
        }
        List<String> topSearch = this.root.search(inputString, count);
        return this.mdFile2Map.assemble(topSearch, inputString, count);
    }

    public List<OperatorRecord> searchFullMatch(String inputString) {
        return this.mdFile2Map.fetchAllMatch(inputString);
    }
}

