/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.apiscanning.handler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.mindspore.ide.toolkit.apiscanning.ApiMappingProjectUI;
import com.mindspore.ide.toolkit.apiscanning.TransApiAction;
import com.mindspore.ide.toolkit.apiscanning.VirtualFileNode;
import com.mindspore.ide.toolkit.common.utils.MSPsiUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ApiMappingHandler {
    private static final Logger log = Logger.getInstance(ApiMappingHandler.class);
    private static final String NO_PACKAGE_PLACEHOLDER = "<no package>";
    private final Map<String, Content> contentMap = new HashMap<String, Content>();
    private Map<String, String> importMap = new LinkedHashMap<String, String>();
    private Map<String, String> fromMap;
    private Map<String, String> fromAsMap;
    private static Map<Content, ApiMappingProjectUI> projectContentMap = new HashMap<Content, ApiMappingProjectUI>();
    private Set<String> apiNameList;
    private Project myProject;
    private Set<String> apiBlurredNameList;
    public static Map<Project, VirtualFile[]> excludedFilesMap = new HashMap<Project, VirtualFile[]>();
    private VirtualFile root;
    private ToolWindow toolWindow;
    private ContentManager contentManager;
    private final Set<VirtualFile> virtualFileSet = new LinkedHashSet<VirtualFile>();
    private Set<String> apiNameFiltering = new LinkedHashSet<String>();
    private Set<String> apiBlurredNameFiltering = new LinkedHashSet<String>();
    private final VirtualFileFilter virtualFileFilter = new VirtualFileFilter(){

        public boolean accept(@NotNull VirtualFile file) {
            VirtualFile[] excludedFiles;
            if (file == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((excludedFiles = excludedFilesMap.get(ApiMappingHandler.this.myProject)) != null && excludedFiles.length != 0) {
                return !Arrays.asList(excludedFiles).contains(file);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/mindspore/ide/toolkit/apiscanning/handler/ApiMappingHandler$1", "accept"));
        }
    };
    private final ContentIterator contentIterator = fileOrDir -> {
        try {
            this.virtualFileSet.add(fileOrDir);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    };

    public ApiMappingHandler(Project project) {
        this.myProject = project;
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        this.toolWindow = toolWindowManager.getToolWindow("MindSporeApiMapping");
        this.contentManager = this.toolWindow.getContentManager();
        this.contentManager.addContentManagerListener(new ContentManagerListener(){

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                projectContentMap.remove(event.getContent());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/mindspore/ide/toolkit/apiscanning/handler/ApiMappingHandler$2", "contentRemoved"));
            }
        });
    }

    public void iterateVfsTreeNode(VirtualFile virtualFileRoot) {
        this.root = virtualFileRoot;
        VfsUtilCore.iterateChildrenRecursively((VirtualFile)this.root, (VirtualFileFilter)this.virtualFileFilter, (ContentIterator)this.contentIterator);
    }

    public void handleProjectApiMapping(List<PsiFile> psiFiles) {
        this.importMap = new HashMap<String, String>();
        this.fromMap = new HashMap<String, String>();
        this.fromAsMap = new HashMap<String, String>();
        this.apiNameList = new LinkedHashSet<String>();
        LinkedList<Object[]> apiNameNullList = new LinkedList<Object[]>();
        List<Object[]> straightApiMappingList = this.sortList(this.apiNameFiltering, apiNameNullList);
        List<Object[]> blurredApiMappingList = this.sortList(this.apiBlurredNameFiltering, null);
        ApiMappingProjectUI projectMap = new ApiMappingProjectUI(this.trans(straightApiMappingList), this.trans(blurredApiMappingList), this.trans(apiNameNullList), this.myProject, this.root, this.root);
        JBScrollPane jbScrollPane = new JBScrollPane((Component)projectMap.splitPane);
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)jbScrollPane, this.myProject.getName(), true);
        this.contentManager.addContent(content);
        projectContentMap.put(content, projectMap);
        this.contentManager.setSelectedContent(content, false, false);
        this.toolWindow.show();
    }

    public void handleTreeNodeSelection(@NotNull VirtualFileNode virtualFileNode) throws Exception {
        if (virtualFileNode == null) {
            ApiMappingHandler.$$$reportNull$$$0(0);
        }
        final ApiMappingHandler apiMappingHandler = this;
        final VirtualFile chosenFile = virtualFileNode.getVirtualFile();
        long startTime = System.currentTimeMillis();
        Boolean isRun = (Boolean)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<Boolean, Exception>(this.myProject, "Scanning", false){

            public Boolean compute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    VfsUtilCore.iterateChildrenRecursively((VirtualFile)chosenFile, (VirtualFileFilter)ApiMappingHandler.this.virtualFileFilter, (ContentIterator)ApiMappingHandler.this.contentIterator);
                    List psiFiles = PsiUtilCore.toPsiFiles((PsiManager)PsiManager.getInstance((Project)this.myProject), ApiMappingHandler.this.virtualFileSet);
                    ApiMappingHandler.this.importMap = new HashMap<String, String>();
                    ApiMappingHandler.this.fromMap = new HashMap<String, String>();
                    ApiMappingHandler.this.fromAsMap = new HashMap<String, String>();
                    ApiMappingHandler.this.apiNameList = new LinkedHashSet<String>();
                    psiFiles.stream().filter(psiFile -> psiFile.getName().contains(".py")).forEach(apiMappingHandler::getProjectApiMappingInfoByPsi);
                });
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/mindspore/ide/toolkit/apiscanning/handler/ApiMappingHandler$3", "compute"));
            }
        });
        if (!isRun.booleanValue()) {
            return;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow = toolWindowManager.getToolWindow("MindSporeApiMapping");
        LinkedList<Object[]> apiNameNullList = new LinkedList<Object[]>();
        List<Object[]> straightApiMappingList = this.sortList(this.apiNameFiltering, apiNameNullList);
        List<Object[]> blurredApiMappingList = this.sortList(this.apiBlurredNameFiltering, null);
        ApiMappingProjectUI projectMap = projectContentMap.get(this.contentManager.getSelectedContent());
        String name = chosenFile.getName();
        projectMap.reload(this.trans(straightApiMappingList), this.trans(blurredApiMappingList), this.trans(apiNameNullList), name);
        ContentManager contentManagerLocal = toolWindow.getContentManager();
        contentManagerLocal.removeContent(contentManagerLocal.getSelectedContent(), true);
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)new JBScrollPane((Component)projectMap.splitPane), name, true);
        contentManagerLocal.addContent(content);
        projectContentMap.put(content, projectMap);
        contentManagerLocal.setSelectedContent(content, true, true);
        toolWindow.show();
        log.info("api mapping for project const" + (System.currentTimeMillis() - startTime) + " ms");
    }

    public void getProjectApiMappingInfoByPsi(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ApiMappingHandler.$$$reportNull$$$0(1);
        }
        this.apiBlurredNameList = new LinkedHashSet<String>();
        this.translateImport((PsiElement)psiFile, this.importMap, this.fromMap, this.fromAsMap);
        this.translateCallExpression((PsiElement)psiFile);
        Set<String> apiNameFiltering1 = this.filteringApi(this.apiNameList);
        Set<String> apiBlurredNameFiltering1 = this.filteringApi(this.apiBlurredNameList);
        this.apiNameFiltering.addAll(apiNameFiltering1);
        this.apiBlurredNameFiltering.addAll(apiBlurredNameFiltering1);
    }

    public Set<VirtualFile> getVirtualFileSet() {
        return this.virtualFileSet;
    }

    private Set<String> filteringApi(Set<String> apiNameList) {
        return TransApiAction.filteringApi(apiNameList);
    }

    private Object[][] trans(List<Object[]> data) {
        return TransApiAction.trans(data);
    }

    private List<Object[]> sortList(Set<String> apiNameList, List<Object[]> apiNameNullList) {
        Set<String> apiString = this.filteringData(apiNameList);
        this.importMapDataSort(apiString, apiNameList);
        this.fromMapDataSort(apiString, apiNameList);
        this.fromAsMapDataSort(apiString, apiNameList);
        return this.searchData(this.filteringData(apiString), apiNameNullList);
    }

    private void importMapDataSort(Set<String> apiString, Set<String> apiNameList) {
        this.importMap.forEach((key, value) -> {
            if (value == null) {
                this.importMapDataSortIf(apiString, apiNameList, (String)key);
            } else {
                this.importMapDataSortElse(apiString, apiNameList, (String)key, (String)value);
            }
        });
    }

    private void fromMapDataSort(Set<String> apiString, Set<String> apiNameList) {
        this.fromMap.forEach((key, value) -> {
            if (value == null) {
                for (String str : apiNameList) {
                    apiString.add(key + "." + str);
                }
            } else {
                this.fromMapDataSortElse(apiString, apiNameList, (String)key, (String)value);
            }
        });
    }

    private void fromMapDataSortElse(Set<String> apiString, Set<String> apiNameList, String key, String value) {
        TransApiAction.fromMapDataSortElse(apiString, apiNameList, key, value);
    }

    private void fromAsMapDataSort(Set<String> apiString, Set<String> apiNameList) {
        this.fromAsMap.forEach((key, value) -> {
            for (String str : apiNameList) {
                String[] split = str.split("\\.");
                if (split.length > 0) {
                    if (!split[0].equals(value)) continue;
                    apiString.add(key + str.replaceFirst(split[0], ""));
                    continue;
                }
                if (!str.equals(value)) continue;
                apiString.add((String)key);
            }
        });
    }

    private void importMapDataSortIf(Set<String> apiString, Set<String> apiNameList, String key) {
        TransApiAction.importMapDataSortIf(apiString, apiNameList, key);
    }

    private void importMapDataSortElse(Set<String> apiString, Set<String> apiNameList, String key, String value) {
        TransApiAction.importMapDataSortElse(apiString, apiNameList, key, value);
    }

    private Set<String> filteringData(Set<String> apiNameList) {
        return TransApiAction.filteringData(apiNameList);
    }

    private List<Object[]> searchData(Set<String> apiStringSet, List<Object[]> apiNameNullList) {
        return TransApiAction.searchData(apiStringSet, apiNameNullList);
    }

    private void translateCallExpressionInPyCallExpression(PsiElement psiElement, List<String[]> formerFunction) {
        for (PsiElement element : psiElement.getChildren()) {
            if (element instanceof PyCallExpression) {
                String value;
                String key;
                PyCallExpression pyCallExpression = (PyCallExpression)element;
                String apiString = pyCallExpression.getCallee().getText();
                int lastDot = apiString.lastIndexOf(46);
                if (lastDot > 0 && apiString.length() > lastDot) {
                    key = apiString.substring(0, lastDot);
                    value = apiString.substring(lastDot + 1);
                } else {
                    key = apiString;
                    value = NO_PACKAGE_PLACEHOLDER;
                }
                formerFunction.add(new String[]{key, value});
                this.translateCallExpressionInPyCallExpression(element, formerFunction);
                continue;
            }
            if (element instanceof PyReferenceExpression && element.getChildren().length > 0 && !element.getText().toLowerCase().equals(element.getText())) {
                this.apiNameList.add(element.getText());
                this.translateCallExpressionInPyCallExpression(element, formerFunction);
                continue;
            }
            this.translateCallExpressionInPyCallExpression(element, formerFunction);
        }
        if (formerFunction.size() <= 0) {
            log.info("The length of the formerFunction is 0");
        } else {
            int last = formerFunction.size() - 1;
            String lastKey = formerFunction.get(last)[0];
            formerFunction.forEach(record -> {
                if (record[0].equals(lastKey)) {
                    if (NO_PACKAGE_PLACEHOLDER.equals(record[1])) {
                        this.apiNameList.add(lastKey);
                    } else {
                        this.apiNameList.add(lastKey + "." + record[1]);
                    }
                } else if (NO_PACKAGE_PLACEHOLDER.equals(record[1])) {
                    this.apiBlurredNameList.add(lastKey);
                } else {
                    this.apiBlurredNameList.add(lastKey + "." + record[1]);
                }
            });
        }
        formerFunction.clear();
    }

    private void translateCallExpression(PsiElement psiElement) {
        ArrayList<String[]> formerFunction = new ArrayList<String[]>();
        for (PsiElement element : psiElement.getChildren()) {
            if (element instanceof PyCallExpression) {
                String value;
                String key;
                PyCallExpression pyCallExpression = (PyCallExpression)element;
                String apiString = pyCallExpression.getCallee().getText();
                int lastDot = apiString.lastIndexOf(46);
                if (lastDot > 0 && apiString.length() > lastDot) {
                    key = apiString.substring(0, lastDot);
                    value = apiString.substring(lastDot + 1);
                } else {
                    key = apiString;
                    value = NO_PACKAGE_PLACEHOLDER;
                }
                formerFunction.add(new String[]{key, value});
                this.translateCallExpressionInPyCallExpression(element, formerFunction);
                continue;
            }
            if (element instanceof PyReferenceExpression && !MSPsiUtils.isPsiImport(element) && element.getChildren().length > 0 && !element.getText().toLowerCase().equals(element.getText())) {
                this.apiNameList.add(element.getText());
                continue;
            }
            this.translateCallExpression(element);
        }
    }

    private void translateImport(PsiElement psiElement, Map<String, String> importMap, Map<String, String> fromMap, Map<String, String> fromAsMap) {
        TransApiAction.translateImport(psiElement, importMap, fromMap, fromAsMap);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFileNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "com/mindspore/ide/toolkit/apiscanning/handler/ApiMappingHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleTreeNodeSelection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getProjectApiMappingInfoByPsi";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

