/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.search.structure;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class TrieNode {
    private static String lastWord;
    private boolean isWord = false;
    private Optional<TrieNode> lastNode;
    private TrieNode parent;
    private Character content;
    private TreeMap<Character, TrieNode> children = new TreeMap(Character::compare);

    public TrieNode() {
        this(null);
    }

    private TrieNode(TrieNode parent) {
        this(null, parent);
    }

    private TrieNode(Character content, TrieNode parent) {
        this.content = content;
        this.parent = parent;
    }

    private boolean isWord() {
        return this.isWord;
    }

    private void becomeWord() {
        this.isWord = true;
    }

    public boolean addWord(String word) {
        if (this.parent != null) {
            return this.parent.addWord(word);
        }
        return this.addSuffix(word.toLowerCase(Locale.ENGLISH).chars().mapToObj(ch -> Character.valueOf((char)ch)).collect(Collectors.toCollection(LinkedList::new)));
    }

    public boolean addSuffix(LinkedList<Character> suffix) {
        if (suffix.isEmpty()) {
            this.becomeWord();
            return true;
        }
        Character nextChar = suffix.pollFirst();
        this.children.putIfAbsent(nextChar, new TrieNode(nextChar, this));
        return this.children.get(nextChar).addSuffix(suffix);
    }

    public List<String> search(String input, int amount) {
        String search = input.toLowerCase(Locale.ENGLISH);
        Optional<Object> nextNode = lastWord != null && search.startsWith(lastWord) ? (this.lastNode.isPresent() ? this.lastNode.flatMap(node -> node.searchNode(search.substring(lastWord.length()).chars().mapToObj(ch -> Character.valueOf((char)ch)).collect(Collectors.toCollection(LinkedList::new)))) : Optional.empty()) : this.searchNode(search.chars().mapToObj(ch -> Character.valueOf((char)ch)).collect(Collectors.toCollection(LinkedList::new)));
        lastWord = search;
        this.lastNode = nextNode;
        if (nextNode.isPresent()) {
            return ((TrieNode)nextNode.get()).dfs(amount);
        }
        return new ArrayList<String>();
    }

    public Optional<TrieNode> searchNode(LinkedList<Character> suffix) {
        if (suffix.isEmpty()) {
            return Optional.of(this);
        }
        Character nextChar = suffix.pollFirst();
        TrieNode nextNode = this.children.get(nextChar);
        if (nextNode == null) {
            return Optional.empty();
        }
        return nextNode.searchNode(suffix);
    }

    public List<String> dfs(int amount) {
        ArrayList<String> result = new ArrayList<String>();
        int count = amount;
        LinkedList<TrieNode> nodes = new LinkedList<TrieNode>();
        nodes.add(this);
        while (count > 0 && !nodes.isEmpty()) {
            TrieNode nextNode = (TrieNode)nodes.pollFirst();
            if (nextNode.isWord()) {
                --count;
                result.add(nextNode.wholeWord());
            }
            nodes.addAll(0, nextNode.getNodeList());
        }
        return result;
    }

    public LinkedList<TrieNode> getNodeList() {
        return new LinkedList<TrieNode>(this.children.values());
    }

    public String wholeWord() {
        return this.wholeWord(new StringBuilder());
    }

    public String wholeWord(StringBuilder stringBuilder) {
        if (this.parent != null) {
            stringBuilder.insert(0, this.content);
            return this.parent.wholeWord(stringBuilder);
        }
        return stringBuilder.toString();
    }
}

