# PyTorch与MindSpore API映射表

<a href="https://gitee.com/mindspore/docs/blob/r2.0/docs/mindspore/source_zh_cn/note/api_mapping/pytorch_api_mapping.md" target="_blank"><img src="https://mindspore-website.obs.cn-north-4.myhuaweicloud.com/website-images/r2.0/resource/_static/logo_source.png"></a>

由社区提供的PyTorch APIs和MindSpore APIs之间的映射，可能在参数、输入、输出、逻辑功能和特定场景等方面存在差异，可详见各API描述或已提供的差异对比。

也欢迎更多的MindSpore开发者参与完善映射内容。

因为框架机制原因，MindSpore不提供PyTorch的以下参数：

|    参数名     |                        功能                        |
| :-----------: | :------------------------------------------------: |
|      out      |                  表示输出的Tensor                  |
|    layout     |                  表示内存分布策略                  |
|    device     |                 表示Tensor存放位置                 |
| requires_grad |                  表示是否更新梯度                  |
|   generator   |                 表示伪随机数生成器                 |
|  pin_memeory  |                表示是否使用锁页内存                |
| memory_format |                表示Tensor的内存格式                |
|    stable     |                  表示是否稳定排序                  |
|    inplace    | 表示在不更改变量内存地址的情况下，直接修改变量的值 |
|  sparse_grad  |                表示是否对梯度稀疏化                |
| size_average  |                  PyTorch废弃参数                   |
|    reduce     |                  PyTorch废弃参数                   |

## PyTorch 1.8.1

### torch

| PyTorch 1.8.1 APIs                                                                           | MindSpore APIs                                                                                                                                                          | 说明                                                                                                                     |
| -------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------ |
| [torch.abs](https://pytorch.org/docs/1.8.1/generated/torch.abs.html)                             | [mindspore.ops.abs](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.abs.html)                                                 | 一致        |
| [torch.absolute](https://pytorch.org/docs/1.8.1/generated/torch.absolute.html)                             | [mindspore.ops.absolute](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.absolute.html)                                                 |   一致             |
| [torch.acos](https://pytorch.org/docs/1.8.1/generated/torch.acos.html)                           | [mindspore.ops.acos](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.acos.html)                                              | 一致 |
| [torch.acosh](https://pytorch.org/docs/1.8.1/generated/torch.acosh.html)| [mindspore.ops.acosh](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.acosh.html)|一致|
| [torch.add](https://pytorch.org/docs/1.8.1/generated/torch.add.html)| [mindspore.ops.add](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.add.html)|一致|
| [torch.addbmm](https://pytorch.org/docs/1.8.1/generated/torch.addbmm.html)                       | [mindspore.ops.addbmm](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.addbmm.html) |   功能一致，参数名不同|
| [torch.addcdiv](https://pytorch.org/docs/1.8.1/generated/torch.addcdiv.html)| [mindspore.ops.addcdiv](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.addcdiv.html)|一致|
| [torch.addcmul](https://pytorch.org/docs/1.8.1/generated/torch.addcmul.html)| [mindspore.ops.addcmul](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.addcmul.html)|一致|
| [torch.addmm](https://pytorch.org/docs/1.8.1/generated/torch.addmm.html)                         | [mindspore.ops.addmm](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.addmm.html) |   功能一致，参数名不同|
| [torch.addmv](https://pytorch.org/docs/1.8.1/generated/torch.addmv.html)                         | [mindspore.ops.addmv](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.addmv.html) |   功能一致，参数名不同|
| [torch.addr](https://pytorch.org/docs/1.8.1/generated/torch.addr.html)                         | [mindspore.ops.addr](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.addr.html) |   功能一致，参数名不同|
| [torch.all](https://pytorch.org/docs/1.8.1/generated/torch.all.html#torch.all) | [mindspore.ops.all](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.all.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/all.html) |
| [torch.amax](https://pytorch.org/docs/1.8.1/generated/torch.amax.html#torch.amax) | [mindspore.ops.amax](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.amax.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/amax.html) |
| [torch.amin](https://pytorch.org/docs/1.8.1/generated/torch.amin.html#torch.amin) | [mindspore.ops.amin](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.amin.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/amin.html) |
| [torch.angle](https://pytorch.org/docs/1.8.1/generated/torch.angle.html)                         | [mindspore.ops.angle](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.angle.html) |   一致  |
| [torch.any](https://pytorch.org/docs/1.8.1/generated/torch.any.html#torch.any) | [mindspore.ops.any](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.any.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/any.html) |
| [torch.arange](https://pytorch.org/docs/1.8.1/generated/torch.arange.html)| [mindspore.ops.arange](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.arange.html)|一致|
| [torch.arccos](https://pytorch.org/docs/1.8.1/generated/torch.arccos.html)                           | [mindspore.ops.arccos](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.arccos.html)                                              |     一致                    |
| [torch.arccosh](https://pytorch.org/docs/1.8.1/generated/torch.arccosh.html)                     | [mindspore.ops.arccosh](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.arccosh.html)                                              | 一致 |
| [torch.arcsin](https://pytorch.org/docs/1.8.1/generated/torch.arcsin.html)                       | [mindspore.ops.arcsin](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.arcsin.html)                                              |   功能一致，参数名不同|
| [torch.arcsinh](https://pytorch.org/docs/1.8.1/generated/torch.arcsinh.html)                       | [mindspore.ops.arcsinh](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.arcsinh.html)                                              |   功能一致，参数名不同|
| [torch.arctan](https://pytorch.org/docs/1.8.1/generated/torch.arctan.html)                       | [mindspore.ops.arctan](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.arctan.html)                                              |   一致 |
| [torch.arctanh](https://pytorch.org/docs/1.8.1/generated/torch.arctanh.html)                       | [mindspore.ops.arctanh](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.arctanh.html)                                              |   功能一致，参数名不同|
| [torch.argmax](https://pytorch.org/docs/1.8.1/generated/torch.argmax.html) | [mindspore.ops.argmax](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.argmax.html) | 一致 |
| [torch.argmin](https://pytorch.org/docs/1.8.1/generated/torch.argmin.html) | [mindspore.ops.argmin](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.argmin.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/argmin.html) |
| [torch.argsort](https://pytorch.org/docs/1.8.1/generated/torch.argsort.html)                         | [mindspore.ops.argsort](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.argsort.html) |   一致  |
| [torch.asin](https://pytorch.org/docs/1.8.1/generated/torch.asin.html)                           | [mindspore.ops.asin](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.asin.html)                                              |    一致                      |
| [torch.asinh](https://pytorch.org/docs/1.8.1/generated/torch.asinh.html)| [mindspore.ops.asinh](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.asinh.html)|一致|
| [torch.atan](https://pytorch.org/docs/1.8.1/generated/torch.atan.html)                           | [mindspore.ops.atan](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.atan.html)                                              |   一致  |
| [torch.atan2](https://pytorch.org/docs/1.8.1/generated/torch.atan2.html)                         | [mindspore.ops.atan2](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.atan2.html)                                           |  一致 |
| [torch.atanh](https://pytorch.org/docs/1.8.1/generated/torch.atanh.html)| [mindspore.ops.atanh](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.atanh.html)|一致|
| [torch.atleast_1d](https://pytorch.org/docs/1.8.1/generated/torch.atleast_1d.html)                     | [mindspore.ops.atleast_1d](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.atleast_1d.html)                                         |  功能一致，参数名不同 |
| [torch.atleast_2d](https://pytorch.org/docs/1.8.1/generated/torch.atleast_2d.html)                     | [mindspore.ops.atleast_2d](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.atleast_2d.html)                                         |  功能一致，参数名不同 |
| [torch.atleast_3d](https://pytorch.org/docs/1.8.1/generated/torch.atleast_3d.html)                     | [mindspore.ops.atleast_3d](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.atleast_3d.html)                                         |  功能一致，参数名不同 |
| [torch.baddbmm](https://pytorch.org/docs/1.8.1/generated/torch.baddbmm.html)                     | [mindspore.ops.baddbmm](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.baddbmm.html)                                         | 一致 |
| [torch.bartlett_window](https://pytorch.org/docs/1.8.1/generated/torch.bartlett_window.html)     | [mindspore.ops.bartlett_window](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.bartlett_window.html)                          |   [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/bartlett_window.html)                                                                                                                        |
| [torch.bernoulli](https://pytorch.org/docs/1.8.1/generated/torch.bernoulli.html) | [mindspore.ops.bernoulli](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.bernoulli.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/bernoulli.html) |
| [torch.bincount](https://pytorch.org/docs/1.8.1/generated/torch.bincount.html)             | [mindspore.ops.bincount](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.bincount.html)                            |  一致                                                     |
| [torch.bitwise_and](https://pytorch.org/docs/1.8.1/generated/torch.bitwise_and.html)             | [mindspore.ops.bitwise_and](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.bitwise_and.html)                            |   一致 |
| [torch.bitwise_or](https://pytorch.org/docs/1.8.1/generated/torch.bitwise_or.html)               | [mindspore.ops.bitwise_or](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.bitwise_or.html)                               |  一致 |
| [torch.bitwise_xor](https://pytorch.org/docs/1.8.1/generated/torch.bitwise_xor.html)             | [mindspore.ops.bitwise_xor](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.bitwise_xor.html)                            |   一致 |
| [torch.blackman_window](https://pytorch.org/docs/1.8.1/generated/torch.blackman_window.html)     | [mindspore.ops.blackman_window](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.blackman_window.html)                          |    [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/blackman_window.html)  |
| [torch.block_diag](https://pytorch.org/docs/1.8.1/generated/torch.block_diag.html)                     | [mindspore.ops.block_diag](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.block_diag.html)                                         |  功能一致，参数名不同 |
| [torch.bmm](https://pytorch.org/docs/1.8.1/generated/torch.bmm.html) | [mindspore.ops.bmm](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.bmm.html) | 功能一致，参数名不同 |
| [torch.broadcast_to](https://pytorch.org/docs/1.8.1/generated/torch.broadcast_to.html) | [mindspore.ops.broadcast_to](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.broadcast_to.html)                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/broadcast_to.html)        |
| [torch.cat](https://pytorch.org/docs/1.8.1/generated/torch.cat.html)                             | [mindspore.ops.cat](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.cat.html)                                        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/cat.html)           |
| [torch.cdist](https://pytorch.org/docs/1.8.1/generated/torch.cdist.html)                             | [mindspore.ops.cdist](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.cdist.html)                                        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/cdist.html)           |
| [torch.ceil](https://pytorch.org/docs/1.8.1/generated/torch.ceil.html)                           | [mindspore.ops.ceil](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.ceil.html)                                              |    一致 |
| [torch.cholesky](https://pytorch.org/docs/1.8.1/generated/torch.cholesky.html)                           | [mindspore.ops.cholesky](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.cholesky.html)                           | 功能一致，参数名不同 |
| [torch.chunk](https://pytorch.org/docs/1.8.1/generated/torch.chunk.html)                           | [mindspore.ops.chunk](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.chunk.html)                           | 一致|
| [torch.clamp](https://pytorch.org/docs/1.8.1/generated/torch.clamp.html) | [mindspore.ops.clamp](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.clamp.html) |  一致 |
| [torch.clip](https://pytorch.org/docs/1.8.1/generated/torch.clip.html) | [mindspore.ops.clip](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.clip.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/clip.html) |
| [torch.column_stack](https://pytorch.org/docs/1.8.1/generated/torch.column_stack.html) | [mindspore.ops.column_stack](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.column_stack.html) | 一致 |
| [torch.combinations](https://pytorch.org/docs/1.8.1/generated/torch.combinations.html)                     | [mindspore.ops.combinations](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.combinations.html)                                         |  功能一致，参数名不同 |
| [torch.conj](https://pytorch.org/docs/1.8.1/generated/torch.conj.html)                       | [mindspore.ops.conj](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.conj.html)                                              | 一致|
| [torch.copysign](https://pytorch.org/docs/1.8.1/generated/torch.copysign.html)                         | [mindspore.ops.copysign](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.copysign.html) |   功能一致，参数名不同|
| [torch.cos](https://pytorch.org/docs/1.8.1/generated/torch.cos.html)                             | [mindspore.ops.cos](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.cos.html)                                                 |    一致       |
| [torch.cosh](https://pytorch.org/docs/1.8.1/generated/torch.cosh.html)                        | [mindspore.ops.cosh](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.cosh.html)                                              |         一致             |
| [torch.count_nonzero](https://pytorch.org/docs/1.8.1/generated/torch.count_nonzero.html)                         | [mindspore.ops.count_nonzero](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.count_nonzero.html) |   一致|
| [torch.cross](https://pytorch.org/docs/1.8.1/generated/torch.cross.html)          | [mindspore.ops.cross](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.cross.html)                                   | 一致    |
| [torch.cummax](https://pytorch.org/docs/1.8.1/generated/torch.cummax.html) | [mindspore.ops.cummax](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.cummax.html) | 一致 |
| [torch.cummin](https://pytorch.org/docs/1.8.1/generated/torch.cummin.html) | [mindspore.ops.cummin](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.cummin.html) | 一致 |
| [torch.cumprod](https://pytorch.org/docs/1.8.1/generated/torch.cumprod.html) | [mindspore.ops.cumprod](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.cumprod.html) | 一致|
| [torch.cumsum](https://pytorch.org/docs/1.8.1/generated/torch.cumsum.html)                       |   [mindspore.ops.cumsum](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.cumsum.html)                                       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/cumsum.html)                                                                                                                         |
| [torch.deg2rad](https://pytorch.org/docs/1.8.1/generated/torch.deg2rad.html)                         | [mindspore.ops.deg2rad](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.deg2rad.html) |   功能一致，参数名不同|
| [torch.diag](https://pytorch.org/docs/1.8.1/generated/torch.diag.html)                       |   [mindspore.ops.diag](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.diag.html)                                       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/diag.html)                                                                                                                         |
| [torch.diag_embed](https://pytorch.org/docs/1.8.1/generated/torch.diag_embed.html)                         | [mindspore.ops.diag_embed](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.diag_embed.html) |  一致 |
| [torch.diagflat](https://pytorch.org/docs/1.8.1/generated/torch.diagflat.html)                       |   [mindspore.ops.diagflat](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.diagflat.html)                                       | 一致 |
| [torch.diagonal](https://pytorch.org/docs/1.8.1/generated/torch.diagonal.html)                       |   [mindspore.ops.diagonal](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.diagonal.html)                                       | 一致 |
| [torch.diff](https://pytorch.org/docs/1.8.1/generated/torch.diff.html)                       |   [mindspore.ops.diff](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.diff.html)                                       | 功能一致，参数名不同 |
| [torch.digamma](https://pytorch.org/docs/1.8.1/generated/torch.digamma.html)                         | [mindspore.ops.digamma](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.digamma.html) |  一致 |
| [torch.dist](https://pytorch.org/docs/1.8.1/generated/torch.dist.html)                         | [mindspore.ops.dist](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.dist.html) |  一致 |
| [torch.div](https://pytorch.org/docs/1.8.1/generated/torch.div.html)                            |  [mindspore.ops.div](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.div.html)                                                 |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/div.html)                                                                                                                        |
| [torch.divide](https://pytorch.org/docs/1.8.1/generated/torch.divide.html)                            |  [mindspore.ops.divide](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.divide.html)                                                 |  一致  |
| [torch.dot](https://pytorch.org/docs/1.8.1/generated/torch.dot.html) |  [mindspore.ops.tensor_dot](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.tensor_dot.html) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/tensor_dot.html) |
| [torch.dstack](https://pytorch.org/docs/1.8.1/generated/torch.dstack.html)                     | [mindspore.ops.dstack](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.dstack.html)                                         |  功能一致，参数名不同 |
| [torch.empty](https://pytorch.org/docs/1.8.1/generated/torch.empty.html)                         | [mindspore.numpy.empty](https://mindspore.cn/docs/zh-CN/r2.0/api_python/numpy/mindspore.numpy.empty.html)                                   |      [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/mindspore.numpy.empty.html)                                                                                                                      |
| [torch.empty_like](https://pytorch.org/docs/1.8.1/generated/torch.empty_like.html)               | [mindspore.numpy.empty_like](https://mindspore.cn/docs/zh-CN/r2.0/api_python/numpy/mindspore.numpy.empty_like.html)                    |    [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/mindspore.numpy.empty_like.html)                                                                                                                        |
| [torch.eig](https://pytorch.org/docs/1.8.1/generated/torch.eig.html)               | [mindspore.ops.eig](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.eig.html)                    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/eig.html)
| [torch.einsum](https://pytorch.org/docs/1.8.1/generated/torch.einsum.html)               | [mindspore.ops.einsum](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.einsum.html)                    | 一致 |
| [torch.eq](https://pytorch.org/docs/1.8.1/generated/torch.eq.html)                               |  [mindspore.ops.equal](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.equal.html)                                           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/equal.html)                                                                                                                         |
| [torch.equal](https://pytorch.org/docs/1.8.1/generated/torch.equal.html)                               |  [mindspore.ops.equal](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.equal.html)                                           | 一致           |
| [torch.erf](https://pytorch.org/docs/1.8.1/generated/torch.erf.html)                           | [mindspore.ops.erf](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.erf.html)                                              | 一致   |
| [torch.erfc](https://pytorch.org/docs/1.8.1/generated/torch.erfc.html)                           | [mindspore.ops.erfc](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.erfc.html)                                              |  一致   |
| [torch.erfinv](https://pytorch.org/docs/1.8.1/generated/torch.erfinv.html)                       | [mindspore.ops.erfinv](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.erfinv.html)                                        |     一致    |
| [torch.exp](https://pytorch.org/docs/1.8.1/generated/torch.exp.html)                | [mindspore.ops.exp](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.exp.html)      |  一致    |
| [torch.exp2](https://pytorch.org/docs/1.8.1/generated/torch.exp2.html)                         | [mindspore.ops.exp2](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.exp2.html) |   一致|
| [torch.expm1](https://pytorch.org/docs/1.8.1/generated/torch.expm1.html)                        | [mindspore.ops.expm1](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.expm1.html)                                           |  一致|
| [torch.eye](https://pytorch.org/docs/1.8.1/generated/torch.eye.html)                             | [mindspore.ops.eye](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.eye.html)                                                 | 一致 |
| [torch.flatten](https://pytorch.org/docs/1.8.1/generated/torch.flatten.html) | [mindspore.ops.flatten](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.flatten.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/flatten.html) |
| [torch.float_power](https://pytorch.org/docs/1.8.1/generated/torch.float_power.html)             | [mindspore.ops.float_power](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.float_power.html)                           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/float_power.html)                                                                                                                      |
| [torch.flip](https://pytorch.org/docs/1.8.1/generated/torch.flip.html)                           | [mindspore.ops.flip](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.flip.html)                           | 功能一致，参数名不同|
| [torch.fliplr](https://pytorch.org/docs/1.8.1/generated/torch.fliplr.html)                       | [mindspore.ops.fliplr](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.fliplr.html)                       | 功能一致，参数名不同|
| [torch.flipud](https://pytorch.org/docs/1.8.1/generated/torch.flipud.html)                       | [mindspore.ops.flipud](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.flipud.html)                       | 功能一致，参数名不同|
| [torch.floor](https://pytorch.org/docs/1.8.1/generated/torch.floor.html) | [mindspore.ops.floor](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.floor.html) |     一致                                                     |
| [torch.fmax](https://pytorch.org/docs/1.8.1/generated/torch.fmax.html)                         | [mindspore.ops.fmax](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.fmax.html) |  一致 |
| [torch.fmod](https://pytorch.org/docs/1.8.1/generated/torch.fmod.html)                       | [mindspore.ops.fmod](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.fmod.html)                                   | 一致 |
| [torch.frac](https://pytorch.org/docs/1.8.1/generated/torch.frac.html)                       | [mindspore.ops.frac](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.frac.html)                                   | 功能一致，参数名不同 |
| [torch.full](https://pytorch.org/docs/1.8.1/generated/torch.full.html)                           | [mindspore.ops.full](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.full.html)                                      |   [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/full.html)                                   |
| [torch.full_like](https://pytorch.org/docs/1.8.1/generated/torch.full_like.html)                 | [mindspore.ops.full_like](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.full_like.html)                       |    一致       |
| [torch.gather](https://pytorch.org/docs/1.8.1/generated/torch.gather.html) | [mindspore.ops.gather_elements](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.gather_elements.html) | 一致 |
| [torch.gcd](https://pytorch.org/docs/1.8.1/generated/torch.gcd.html)                 | [mindspore.ops.gcd](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.gcd.html)                       |    一致                |
| [torch.ge](https://pytorch.org/docs/1.8.1/generated/torch.ge.html)                 | [mindspore.ops.ge](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.ge.html)                       |    功能一致，参数名不同                   |
| [torch.geqrf](https://pytorch.org/docs/1.8.1/generated/torch.geqrf.html)                 | [mindspore.ops.geqrf](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.geqrf.html)                       |    一致                |
| [torch.ger](https://pytorch.org/docs/1.8.1/generated/torch.ger.html) | [mindspore.ops.ger](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.ger.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/ger.html) |
| [torch.greater](https://pytorch.org/docs/1.8.1/generated/torch.greater.html)                 | [mindspore.ops.greater](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.greater.html)                       |    功能一致，参数名不同                   |
| [torch.greater_equal](https://pytorch.org/docs/1.8.1/generated/torch.greater_equal.html)                 | [mindspore.ops.greater_equal](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.greater_equal.html)                       |    功能一致，参数名不同                   |
| [torch.gt](https://pytorch.org/docs/1.8.1/generated/torch.gt.html)                 | [mindspore.ops.gt](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.gt.html)                       |    功能一致，参数名不同                   |
| [torch.hann_window](https://pytorch.org/docs/1.8.1/generated/torch.hann_window.html)             | [mindspore.numpy.hanning](https://mindspore.cn/docs/zh-CN/r2.0/api_python/numpy/mindspore.numpy.hanning.html)                             |    [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/mindspore.numpy.hanning.html)                                                                                                                      |
| [torch.hann_window](https://pytorch.org/docs/1.8.1/generated/torch.hann_window.html)                     | [mindspore.ops.hann_window](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.hann_window.html)                                         |  一致 |
| [torch.heaviside](https://pytorch.org/docs/1.8.1/generated/torch.heaviside.html) | [mindspore.ops.heaviside](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.heaviside.html) | 一致 |
| [torch.hstack](https://pytorch.org/docs/1.8.1/generated/torch.hstack.html) | [mindspore.ops.hstack](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.hstack.html) | 一致 |
| [torch.histc](https://pytorch.org/docs/1.8.1/generated/torch.histc.html) | [mindspore.ops.histc](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.histc.html) | 一致 |
| [torch.hypot](https://pytorch.org/docs/1.8.1/generated/torch.hypot.html) | [mindspore.ops.hypot](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.hypot.html) | 一致 |
| [torch.hamming_window](https://pytorch.org/docs/1.8.1/generated/torch.hamming_window.html)             | [mindspore.ops.hamming_window](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.hamming_window.html)                             |  一致                              |
| [torch.i0](https://pytorch.org/docs/1.8.1/generated/torch.i0.html) | [mindspore.ops.i0](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.i0.html) | 一致 |
| [torch.igamma](https://pytorch.org/docs/1.8.1/generated/torch.igamma.html)| [mindspore.ops.igamma](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.igamma.html)|一致|
| [torch.igammac](https://pytorch.org/docs/1.8.1/generated/torch.igammac.html)| [mindspore.ops.igammac](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.igammac.html)|一致|
| [torch.imag](https://pytorch.org/docs/1.8.1/generated/torch.imag.html) | [mindspore.ops.imag](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.imag.html)  | 一致 |
| [torch.index_select](https://pytorch.org/docs/1.8.1/generated/torch.index_select.html) | [mindspore.ops.index_select](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.index_select.html) | 功能一致，参数名不同 |
| [torch.inner](https://pytorch.org/docs/1.8.1/generated/torch.inner.html) | [mindspore.ops.inner](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.inner.html) | 功能一致，参数名不同 |
| [torch.inverse](https://pytorch.org/docs/1.8.1/generated/torch.inverse.html) | [mindspore.ops.inverse](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.inverse.html) | 一致 |
| [torch.isclose](https://pytorch.org/docs/1.8.1/generated/torch.isclose.html) | [mindspore.ops.isclose](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.isclose.html) | 功能一致，参数名不同 |
| [torch.isfinite](https://pytorch.org/docs/1.8.1/generated/torch.isfinite.html) | [mindspore.ops.isfinite](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.isfinite.html) | 一致 |
| [torch.isinf](https://pytorch.org/docs/1.8.1/generated/torch.isinf.html) | [mindspore.ops.isinf](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.isinf.html) | 一致 |
| [torch.isnan](https://pytorch.org/docs/1.8.1/generated/torch.isnan.html) | [mindspore.ops.isnan](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.isnan.html) | 一致 |
| [torch.isneginf](https://pytorch.org/docs/1.8.1/generated/torch.isneginf.html) | [mindspore.ops.isneginf](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.isneginf.html) | 一致 |
| [torch.isposinf](https://pytorch.org/docs/1.8.1/generated/torch.isposinf.html) | [mindspore.ops.isposinf](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.isposinf.html) | 一致 |
| [torch.isreal](https://pytorch.org/docs/1.8.1/generated/torch.isreal.html) | [mindspore.ops.isreal](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.isreal.html) | 一致 |
| [torch.is_complex](https://pytorch.org/docs/1.8.1/generated/torch.is_complex.html) | [mindspore.ops.is_complex](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.is_complex.html) | 功能一致，参数名不同|
| [torch.is_floating_point](https://pytorch.org/docs/1.8.1/generated/torch.is_floating_point.html) | [mindspore.ops.is_floating_point](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.is_floating_point.html) | 功能一致，参数名不同|
| [torch.is_tensor](https://pytorch.org/docs/1.8.1/generated/torch.is_tensor.html#torch.is_tensor) | [mindspore.ops.is_tensor](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.is_tensor.html) | 一致 |
| [torch.kaiser_window](https://pytorch.org/docs/1.8.1/generated/torch.kaiser_window.html)                     | [mindspore.ops.kaiser_window](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.kaiser_window.html)                                         | 一致 |
| [torch.kron](https://pytorch.org/docs/1.8.1/generated/torch.kron.html)                         | [mindspore.ops.kron](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.kron.html) |   功能一致，参数名不同|
| [torch.lcm](https://pytorch.org/docs/1.8.1/generated/torch.lcm.html) | [mindspore.ops.lcm](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.lcm.html) | 一致 |
| [torch.ldexp](https://pytorch.org/docs/1.8.1/generated/torch.ldexp.html)                         | [mindspore.ops.ldexp](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.ldexp.html) |   功能一致，参数名不同|
| [torch.le](https://pytorch.org/docs/1.8.1/generated/torch.le.html) | [mindspore.ops.le](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.le.html) | 功能一致，参数名不同 |
| [torch.lerp](https://pytorch.org/docs/1.8.1/generated/torch.lerp.html) | [mindspore.ops.lerp](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.lerp.html) | 功能一致，参数名不同 |
| [torch.less](https://pytorch.org/docs/1.8.1/generated/torch.less.html) | [mindspore.ops.less](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.less.html) | 功能一致，参数名不同 |
| [torch.less_equal](https://pytorch.org/docs/1.8.1/generated/torch.less_equal.html) | [mindspore.ops.less_equal](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.less_equal.html) | 功能一致，参数名不同 |
| [torch.linalg.norm](https://pytorch.org/docs/1.8.1/linalg.html#torch.linalg.norm) | [mindspore.ops.norm](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.norm.html) | 一致 |
| [torch.linalg.qr](https://pytorch.org/docs/1.8.1/linalg.html#torch.linalg.qr) | [mindspore.ops.qr](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.qr.html) | [功能一致，数据类型不同](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/qr.html) |
| [torch.linspace](https://pytorch.org/docs/1.8.1/generated/torch.linspace.html) | [mindspore.ops.linspace](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.linspace.html) | 一致 |
| [torch.log](https://pytorch.org/docs/1.8.1/generated/torch.log.html) | [mindspore.ops.log](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.log.html) |   一致                 |
| [torch.log2](https://pytorch.org/docs/1.8.1/generated/torch.log2.html)                         | [mindspore.ops.log2](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.log2.html) |  一致 |
| [torch.log10](https://pytorch.org/docs/1.8.1/generated/torch.log10.html)                         | [mindspore.ops.log10](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.log10.html) |  一致 |
| [torch.logaddexp](https://pytorch.org/docs/1.8.1/generated/torch.logaddexp.html)                         | [mindspore.ops.logaddexp](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.logaddexp.html) | 一致 |
| [torch.logaddexp2](https://pytorch.org/docs/1.8.1/generated/torch.logaddexp2.html)                         | [mindspore.ops.logaddexp2](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.logaddexp2.html) |   一致 |
| [torch.log1p](https://pytorch.org/docs/1.8.1/generated/torch.log1p.html#torch.log1p) | [mindspore.ops.log1p](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.log1p.html#mindspore.ops.log1p) |   功能一致，参数名不同                    |
| [torch.logical_and](https://pytorch.org/docs/1.8.1/generated/torch.logical_and.html) | [mindspore.ops.logical_and](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.logical_and.html) | 功能一致，参数名不同 |
| [torch.logical_not](https://pytorch.org/docs/1.8.1/generated/torch.logical_not.html) | [mindspore.ops.logical_not](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.logical_not.html) | 功能一致，参数名不同 |
| [torch.logical_or](https://pytorch.org/docs/1.8.1/generated/torch.logical_or.html) | [mindspore.ops.logical_or](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.logical_or.html) | 功能一致，参数名不同  |
| [torch.logical_xor](https://pytorch.org/docs/1.8.1/generated/torch.logical_xor.html) | [mindspore.ops.logical_xor](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.logical_xor.html) | 一致 |
| [torch.logit](https://pytorch.org/docs/1.8.1/generated/torch.logit.html)| [mindspore.ops.logit](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.logit.html)|功能一致，参数名不同|
| [torch.logspace](https://pytorch.org/docs/1.8.1/generated/torch.logspace.html) | [mindspore.ops.logspace](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.logspace.html) | 一致 |
| [torch.logsumexp](https://pytorch.org/docs/1.8.1/generated/torch.logsumexp.html) | [mindspore.ops.logsumexp](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.logsumexp.html) | 一致 |
| [torch.lt](https://pytorch.org/docs/1.8.1/generated/torch.lt.html) | [mindspore.ops.lt](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.lt.html) | 一致 |
| [torch.masked_select](https://pytorch.org/docs/1.8.1/generated/torch.masked_select.html) | [mindspore.ops.masked_select](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.masked_select.html) | 一致 |
| [torch.matmul](https://pytorch.org/docs/1.8.1/generated/torch.matmul.html#torch.matmul) | [mindspore.ops.matmul](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.matmul.html) | 一致 |
| [torch.max](https://pytorch.org/docs/1.8.1/generated/torch.max.html) | [mindspore.ops.max](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.max.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/max.html) |
| [torch.maximum](https://pytorch.org/docs/1.8.1/generated/torch.maximum.html) | [mindspore.ops.maximum](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.maximum.html) | 功能一致，参数名不同 |
| [torch.mean](https://pytorch.org/docs/1.8.1/generated/torch.mean.html) | [mindspore.ops.mean](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.mean.html) | 功能一致，参数名不同 |
| [torch.median](https://pytorch.org/docs/1.8.1/generated/torch.median.html) | [mindspore.ops.median](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.median.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/median.html) |
| [torch.meshgrid](https://pytorch.org/docs/1.8.1/generated/torch.meshgrid.html#torch.meshgrid) | [mindspore.ops.meshgrid](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.meshgrid.html) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/meshgrid.html)                    |
| [torch.mm](https://pytorch.org/docs/1.8.1/generated/torch.mm.html)| [mindspore.ops.mm](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.mm.html)|功能一致，参数名不同|
| [torch.mul](https://pytorch.org/docs/1.8.1/generated/torch.mul.html#torch.mul) | [mindspore.ops.mul](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.mul.html#mindspore.ops.mul)  |    功能一致，参数名不同|
| [torch.min](https://pytorch.org/docs/1.8.1/generated/torch.min.html) | [mindspore.ops.min](https://www.mindspore.cn/docs/zh-CN//r2.0/api_python/ops/mindspore.ops.min.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/min.html) |
| [torch.minimum](https://pytorch.org/docs/1.8.1/generated/torch.minimum.html) | [mindspore.ops.minimum](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.minimum.html) | 功能一致，参数名不同 |
| [torch.msort](https://pytorch.org/docs/1.8.1/generated/torch.msort.html) | [mindspore.ops.msort](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.msort.html) |    功能一致，参数名不同|
| [torch.moveaxis](https://pytorch.org/docs/1.8.1/generated/torch.moveaxis.html) | [mindspore.ops.moveaxis](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.moveaxis.html) | 一致 |
| [torch.movedim](https://pytorch.org/docs/1.8.1/generated/torch.movedim.html) | [mindspore.ops.movedim](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.movedim.html) | 一致 |
| [torch.multinomial](https://pytorch.org/docs/1.8.1/generated/torch.multinomial.html) | [mindspore.ops.multinomial](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.multinomial.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/multinomial.html) |
| [torch.multiply](https://pytorch.org/docs/1.8.1/generated/torch.multiply.html) | [mindspore.ops.multiply](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.multiply.html) | 一致|
| [torch.mv](https://pytorch.org/docs/1.8.1/generated/torch.mv.html)                         | [mindspore.ops.mv](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.mv.html) |   功能一致，参数名不同|
| [torch.mvlgamma](https://pytorch.org/docs/1.8.1/generated/torch.mvlgamma.html)| [mindspore.ops.mvlgamma](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.mvlgamma.html)|一致|
| [torch.nan_to_num](https://pytorch.org/docs/1.8.1/generated/torch.nan_to_num.html) | [mindspore.ops.nan_to_num](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.nan_to_num.html) | 功能一致，MindSpore暂时只支持float16与float32输入|
| [torch.nansum](https://pytorch.org/docs/1.8.1/generated/torch.nansum.html) | [mindspore.ops.nansum](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.nansum.html) | 一致 |
| [torch.narrow](https://pytorch.org/docs/1.8.1/generated/torch.narrow.html) | [mindspore.ops.narrow](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.narrow.html) | 功能一致 |
| [torch.ne](https://pytorch.org/docs/1.8.1/generated/torch.ne.html)| [mindspore.ops.ne](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.ne.html)| 功能一致，参数名不同 |
| [torch.neg](https://pytorch.org/docs/1.8.1/generated/torch.neg.html)| [mindspore.ops.neg](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.neg.html)|功能一致，参数名不同|
| [torch.negative](https://pytorch.org/docs/1.8.1/generated/torch.negative.html) | [mindspore.ops.negative](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.negative.html) | 一致|
| [torch.nextafter](https://pytorch.org/docs/1.8.1/generated/torch.nextafter.html) | [mindspore.ops.nextafter](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.nextafter.html) | 一致 |
| [torch.nonzero](https://pytorch.org/docs/1.8.1/generated/torch.nonzero.html) | [mindspore.ops.nonzero](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.nonzero.html) | 功能一致，参数名不同 |
| [torch.normal](https://pytorch.org/docs/1.8.1/generated/torch.normal.html) | [mindspore.ops.normal](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.normal.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/normal.html) |
| [torch.not_equal](https://pytorch.org/docs/1.8.1/generated/torch.not_equal.html) | [mindspore.ops.not_equal](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.not_equal.html) | 一致  |
| [torch.numel](https://pytorch.org/docs/1.8.1/generated/torch.numel.html) | [mindspore.ops.numel](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.numel.html) | 一致 |
| [torch.ones](https://pytorch.org/docs/1.8.1/generated/torch.ones.html) | [mindspore.ops.ones](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.ones.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/ones.html) |
| [torch.ones_like](https://pytorch.org/docs/1.8.1/torch.html#torch.ones_like) | [mindspore.ops.ones_like](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.ones_like.html) | 一致 |
| [torch.orgqr](https://pytorch.org/docs/1.8.1/generated/torch.orgqr.html) | [mindspore.ops.orgqr](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.orgqr.html) | 功能一致，参数名不同 |
| [torch.outer](https://pytorch.org/docs/1.8.1/generated/torch.outer.html)                         | [mindspore.ops.outer](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.outer.html) | 功能一致，参数名不同  |
| [torch.poisson](https://pytorch.org/docs/1.8.1/generated/torch.poisson.html) | [mindspore.ops.random_poisson](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.random_poisson.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/poisson.html) |
| [torch.polar](https://pytorch.org/docs/1.8.1/generated/torch.polar.html)                         | [mindspore.ops.polar](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.polar.html) |  一致 |
| [torch.polygamma](https://pytorch.org/docs/1.8.1/generated/torch.polygamma.html)                         | [mindspore.ops.polygamma](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.polygamma.html) |  一致 |
| [torch.pow](https://pytorch.org/docs/1.8.1/generated/torch.pow.html#torch.pow) | [mindspore.ops.pow](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.pow.html#mindspore.ops.pow) |          功能一致，参数名不同                                              |
| [torch.prod](https://pytorch.org/docs/1.8.1/generated/torch.prod.html#torch.prod) | [mindspore.ops.prod](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.prod.html#mindspore.ops.prod) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/prod.html) |
| [torch.rad2deg](https://pytorch.org/docs/1.8.1/generated/torch.rad2deg.html)                         | [mindspore.ops.rad2deg](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.rad2deg.html) |   功能一致，参数名不同|
| [torch.rand](https://pytorch.org/docs/1.8.1/generated/torch.rand.html) | [mindspore.ops.rand](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.rand.html) | 一致 |
| [torch.rand_like](https://pytorch.org/docs/1.8.1/generated/torch.rand_like.html) | [mindspore.ops.rand_like](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.rand_like.html) | 一致 |
| [torch.randn](https://pytorch.org/docs/1.8.1/generated/torch.randn.html) | [mindspore.ops.randn](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.randn.html) | 一致 |
| [torch.randn_like](https://pytorch.org/docs/1.8.1/generated/torch.randn_like.html) | [mindspore.ops.randn_like](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.randn_like.html) | 一致 |
| [torch.randint](https://pytorch.org/docs/1.8.1/generated/torch.randint.html) | [mindspore.ops.randint](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.randint.html) | [功能一致，默认值不同](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/randint.html) |
| [torch.randint_like](https://pytorch.org/docs/1.8.1/generated/torch.randint_like.html) | [mindspore.ops.randint_like](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.randint_like.html) | [功能一致，默认值不同](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/randint_like.html) |
| [torch.randperm](https://pytorch.org/docs/1.8.1/generated/torch.randperm.html)                         | [mindspore.ops.randperm](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.randperm.html) |  功能一致，参数名不同 |
| [torch.range](https://pytorch.org/docs/1.8.1/generated/torch.range.html#torch.range) | [mindspore.ops.range](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.range.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/range.html) |
| [torch.ravel](https://pytorch.org/docs/1.8.1/generated/torch.ravel.html)                           | [mindspore.ops.ravel](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.ravel.html)      |          一致     |
| [torch.real](https://pytorch.org/docs/1.8.1/generated/torch.real.html)                           | [mindspore.ops.real](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.real.html)      |          功能一致，参数名不同                                              |
| [torch.reciprocal](https://pytorch.org/docs/1.8.1/generated/torch.reciprocal.html) | [mindspore.ops.reciprocal](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.reciprocal.html) |功能一致，参数名不同 |
| [torch.remainder](https://pytorch.org/docs/1.8.1/generated/torch.remainder.html)                         | [mindspore.ops.remainder](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.remainder.html) |   一致 |
| [torch.renorm](https://pytorch.org/docs/1.8.1/generated/torch.renorm.html) | [mindspore.ops.renorm](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.renorm.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/renorm.html) |
| [torch.repeat_interleave](https://pytorch.org/docs/1.8.1/generated/torch.repeat_interleave.html) | [mindspore.ops.repeat_interleave](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.repeat_interleave.html) | 功能一致，参数名不同|
| [torch.reshape](https://pytorch.org/docs/1.8.1/generated/torch.reshape.html#torch.reshape) | [mindspore.ops.reshape](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.reshape.html) | 一致 |
| [torch.rot90](https://pytorch.org/docs/1.8.1/generated/torch.rot90.html)                         | [mindspore.ops.rot90](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.rot90.html) |  一致 |
| [torch.round](https://pytorch.org/docs/1.8.1/generated/torch.round.html)| [mindspore.ops.round](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.round.html)|功能一致，参数名不同|
| [torch.rsqrt](https://pytorch.org/docs/1.8.1/generated/torch.rsqrt.html)                           | [mindspore.ops.rsqrt](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.rsqrt.html)                           | 功能一致，参数名不同|
| [torch.searchsorted](https://pytorch.org/docs/1.8.1/generated/torch.searchsorted.html)                         | [mindspore.ops.searchsorted](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.searchsorted.html) |  一致 |
| [torch.scatter](https://pytorch.org/docs/1.8.1/generated/torch.scatter.html) | [mindspore.ops.scatter](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.scatter.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/scatter.html) |
| [torch.scatter_add](https://pytorch.org/docs/1.8.1/generated/torch.scatter_add.html) | [mindspore.ops.tensor_scatter_elements](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.tensor_scatter_elements.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/scatter_add.html) |
| [torch.sgn](https://pytorch.org/docs/1.8.1/generated/torch.sgn.html)                           | [mindspore.ops.sgn](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.sgn.html)                           | 功能一致，参数名不同|
| [torch.sigmoid](https://pytorch.org/docs/1.8.1/generated/torch.sigmoid.html) | [mindspore.ops.sigmoid](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.sigmoid.html) | 功能一致，参数名不同|
| [torch.sign](https://pytorch.org/docs/1.8.1/generated/torch.sign.html)                           | [mindspore.ops.sign](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.sign.html)                           | 功能一致，参数名不同|
| [torch.signbit](https://pytorch.org/docs/1.8.1/generated/torch.signbit.html)                           | [mindspore.ops.signbit](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.signbit.html)                           | 功能一致，参数名不同|
| [torch.sin](https://pytorch.org/docs/1.8.1/generated/torch.sin.html)| [mindspore.ops.sin](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.sin.html)|一致|
| [torch.sinc](https://pytorch.org/docs/1.8.1/generated/torch.sinc.html)| [mindspore.ops.sinc](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.sinc.html)|一致|
| [torch.sinh](https://pytorch.org/docs/1.8.1/generated/torch.sinh.html)| [mindspore.ops.sinh](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.sinh.html)|功能一致，参数名不同|
| [torch.slogdet](https://pytorch.org/docs/1.8.1/generated/torch.slogdet.html)                         | [mindspore.ops.slogdet](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.slogdet.html)                         | 一致|
| [torch.sort](https://pytorch.org/docs/1.8.1/generated/torch.sort.html)                     | [mindspore.ops.sort](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.sort.html)                                         |  功能一致，参数名不同 |
| [torch.split](https://pytorch.org/docs/1.8.1/generated/torch.split.html)                         | [mindspore.ops.split](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.split.html)                         | 功能一致，参数名不同|
| [torch.stack](https://pytorch.org/docs/1.8.1/generated/torch.stack.html) | [mindspore.ops.stack](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.stack.html) |    一致                                              |
| [torch.squeeze](https://pytorch.org/docs/1.8.1/generated/torch.squeeze.html) | [mindspore.ops.squeeze](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.squeeze.html) | 功能一致，参数名不一致 |
| [torch.std](https://pytorch.org/docs/1.8.1/generated/torch.std.html#torch.std) | [mindspore.ops.std](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.std.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/std.html) |
| [torch.std_mean](https://pytorch.org/docs/1.8.1/generated/torch.std_mean.html#torch.std_mean) | [mindspore.ops.std_mean](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.std_mean.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/std_mean.html) |
| [torch.sqrt](https://pytorch.org/docs/1.8.1/generated/torch.sqrt.html) | [mindspore.ops.sqrt](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.sqrt.html) |  功能一致，参数名不同 |
| [torch.square](https://pytorch.org/docs/1.8.1/generated/torch.square.html)| [mindspore.ops.square](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.square.html)|功能一致，参数名不同|
| [torch.sub](https://pytorch.org/docs/1.8.1/generated/torch.sub.html#torch.sub)  | [mindspore.ops.subtract](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.subtract.html)  | 功能一致，参数名不同 |
| [torch.subtract](https://pytorch.org/docs/1.8.1/generated/torch.subtract.html#torch.subtract)  | [mindspore.ops.subtract](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.subtract.html)  | 功能一致，参数名不同 |
| [torch.sum](https://pytorch.org/docs/1.8.1/generated/torch.sum.html)                             | [mindspore.ops.sum](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.sum.html)                             | 功能一致，参数名不同|
| [torch.svd](https://pytorch.org/docs/1.8.1/generated/torch.svd.html) | [mindspore.ops.svd](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.svd.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/svd.html) |
| [torch.swapaxes](https://pytorch.org/docs/1.8.1/generated/torch.swapaxes.html) | [mindspore.ops.swapaxes](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.swapaxes.html) | 一致 |
| [torch.swapdims](https://pytorch.org/docs/1.8.1/generated/torch.swapdims.html) | [mindspore.ops.swapdims](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.swapdims.html) | 一致 |
| [torch.t](https://pytorch.org/docs/1.8.1/generated/torch.t.html)           | [mindspore.ops.t](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.t.html)           | 一致 |
| [torch.tan](https://pytorch.org/docs/1.8.1/generated/torch.tan.html)| [mindspore.ops.tan](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.tan.html)|功能一致，参数名不同|
| [torch.tanh](https://pytorch.org/docs/1.8.1/generated/torch.tanh.html) | [mindspore.ops.tanh](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.tanh.html) | 功能一致，参数名不同 |
| [torch.tensor_split](https://pytorch.org/docs/1.8.1/generated/torch.tensor_split.html)           | [mindspore.ops.tensor_split](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.tensor_split.html)           | 一致|
| [torch.tile](https://pytorch.org/docs/1.8.1/generated/torch.tile.html)           | [mindspore.ops.tile](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.tile.html)           | 功能一致，参数名不同|
| [torch.topk](https://pytorch.org/docs/1.8.1/generated/torch.topk.html#torch.topk) | [mindspore.ops.topk](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.topk.html) | 功能一致，参数名不同 |
| [torch.trace](https://pytorch.org/docs/1.8.1/generated/torch.trace.html) | [mindspore.ops.trace](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.trace.html) | 一致 |
| [torch.transpose](https://pytorch.org/docs/1.8.1/generated/torch.transpose.html) | [mindspore.ops.swapaxes](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.swapaxes.html) | 一致 |
| [torch.trapz](https://pytorch.org/docs/1.8.1/generated/torch.trapz.html)                         | [mindspore.ops.trapz](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.trapz.html) |  一致 |
| [torch.tril](https://pytorch.org/docs/1.8.1/generated/torch.tril.html)           | [mindspore.ops.tril](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.tril.html)           | 一致 |
| [torch.tril_indices](https://pytorch.org/docs/1.8.1/generated/torch.tril_indices.html)                         | [mindspore.ops.tril_indices](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.tril_indices.html) |  一致 |
| [torch.triu_indices](https://pytorch.org/docs/1.8.1/generated/torch.triu_indices.html)                         | [mindspore.ops.triu_indices](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.triu_indices.html) |  一致 |
| [torch.true_divide](https://pytorch.org/docs/1.8.1/generated/torch.true_divide.html#torch.true_divide) | [mindspore.ops.true_divide](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.true_divide.html) | 一致 |
| [torch.trunc](https://pytorch.org/docs/1.8.1/generated/torch.trunc.html)| [mindspore.ops.trunc](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.trunc.html)|一致|
| [torch.unbind](https://pytorch.org/docs/1.8.1/generated/torch.unbind.html)                           | [mindspore.ops.unbind](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.unbind.html)                            | 一致|
| [torch.unique](https://pytorch.org/docs/1.8.1/generated/torch.unique.html#torch.unique) | [mindspore.ops.unique](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.unique.html#mindspore.ops.unique) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/unique.html) |
| [torch.unique_consecutive](https://pytorch.org/docs/1.8.1/generated/torch.unique_consecutive.html#torch.unique_consecutive) | [mindspore.ops.unique_consecutive](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.unique_consecutive.html#mindspore.ops.unique_consecutive) | 一致 |
| [torch.unsqueeze](https://pytorch.org/docs/1.8.1/generated/torch.unsqueeze.html)| [mindspore.ops.unsqueeze](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.unsqueeze.html)|一致|
| [torch.var](https://pytorch.org/docs/1.8.1/generated/torch.var.html#torch.var) | [mindspore.ops.var](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.var.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/var.html) |
| [torch.var_mean](https://pytorch.org/docs/1.8.1/generated/torch.var_mean.html#torch.var_mean) | [mindspore.ops.var_mean](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.var_mean.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/var_mean.html) |
| [torch.view_as_real](https://pytorch.org/docs/1.8.1/generated/torch.view_as_real.html)                           | [mindspore.ops.view_as_real](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.view_as_real.html)                            | 一致 |
| [torch.vstack](https://pytorch.org/docs/1.8.1/generated/torch.vstack.html)                     | [mindspore.ops.vstack](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.vstack.html)                                         |  功能一致，参数名不同 |
| [torch.where](https://pytorch.org/docs/1.8.1/generated/torch.where.html) | [mindspore.ops.where](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.where.html) | 一致 |
| [torch.xlogy](https://pytorch.org/docs/1.8.1/generated/torch.xlogy.html) | [mindspore.ops.xlogy](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.xlogy.html) | 功能一致，参数名不同|
| [torch.zeros](https://pytorch.org/docs/1.8.1/generated/torch.zeros.html) | [mindspore.ops.zeros](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.zeros.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/zeros.html)|
| [torch.zeros_like](https://pytorch.org/docs/1.8.1/torch.html#torch.zeros_like) | [mindspore.ops.zeros_like](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.zeros_like.html) | 一致 |

### torch.distributions

| PyTorch 1.8.1 APIs                                                                                                   | MindSpore APIs                                                                                                                | 说明 |
| -------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------- | ---- |
| [torch.distributions.laplace.Laplace](https://pytorch.org/docs/1.8.1/distributions.html#torch.distributions.laplace.Laplace) | [mindspore.ops.standard_laplace](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.standard_laplace.html) |   [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/standard_laplace.html)   |

### torch.distributed

| PyTorch 1.8.1 APIs                                                                                                           | MindSpore APIs                                                                                                                                                  | 说明                                                                                                              |
| ---------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------- |
| [torch.distributed.all_gather](https://pytorch.org/docs/1.8.1/distributed.html#torch.distributed.all_gather)                 | [mindspore.ops.AllGather](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.AllGather.html#mindspore.ops.AllGather)                                                                                                                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/all_gather.html)        |
| [torch.distributed.all_reduce](https://pytorch.org/docs/1.8.1/distributed.html#torch.distributed.all_reduce)                 | [mindspore.ops.AllReduce](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.AllReduce.html#mindspore.ops.AllReduce)                                                                                                                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/all_reduce.html)        |
| [torch.distributed.get_rank](https://pytorch.org/docs/1.8.1/distributed.html#torch.distributed.get_rank)                     | [mindspore.communication.get_rank](https://mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore.communication.html#mindspore.communication.get_rank)                                                                                                                          | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/get_rank.html)          |
| [torch.distributed.init_process_group](https://pytorch.org/docs/1.8.1/distributed.html#torch.distributed.init_process_group) | [mindspore.communication.init](https://mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore.communication.html#mindspore.communication.init)                 | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/init.html)         |
| [torch.distributed.new_group](https://pytorch.org/docs/1.8.1/distributed.html#torch.distributed.new_group)                   | [mindspore.communication.create_group](https://mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore.communication.html#mindspore.communication.create_group) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/create_group.html) |

### torch.nn

| PyTorch 1.8.1 APIs                                           | MindSpore APIs                                               | 说明                                                         |
| ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ |
| [torch.nn.AdaptiveAvgPool1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.AdaptiveAvgPool1d.html) | [mindspore.nn.AdaptiveAvgPool1d](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.AdaptiveAvgPool1d.html) | 一致 |
| [torch.nn.AdaptiveAvgPool2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.AdaptiveAvgPool2d.html) | [mindspore.nn.AdaptiveAvgPool2d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.AdaptiveAvgPool2d.html) | 一致 |
| [torch.nn.AdaptiveAvgPool3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.AdaptiveAvgPool3d.html) | [mindspore.nn.AdaptiveAvgPool3d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.AdaptiveAvgPool3d.html) | 一致 |
| [torch.nn.AdaptiveMaxPool1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.AdaptiveMaxPool1d.html) | [mindspore.nn.AdaptiveMaxPool1d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.AdaptiveMaxPool1d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/AdaptiveMaxPool1d.html) |
| [torch.nn.AdaptiveMaxPool2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.AdaptiveMaxPool2d.html) | [mindspore.nn.AdaptiveMaxPool2d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.AdaptiveMaxPool2d.html) | 一致 |
| [torch.nn.AdaptiveMaxPool3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.AdaptiveMaxPool3d.html) | [mindspore.nn.AdaptiveMaxPool3d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.AdaptiveMaxPool3d.html) | 一致 |
| [torch.nn.AvgPool1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.AvgPool1d.html) | [mindspore.nn.AvgPool1d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.AvgPool1d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/AvgPool1d.html)                                                             |
| [torch.nn.AvgPool2d](https://PyTorch.org/docs/1.8.1/generated/torch.nn.AvgPool2d.html) | [mindspore.nn.AvgPool2d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.AvgPool2d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/AvgPool2d.html)                                                             |
| [torch.nn.AvgPool3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.AvgPool3d.html)                 | [mindspore.nn.AvgPool3d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.AvgPool3d.html)                    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/AvgPool3d.html)|
| [torch.nn.BCEWithLogitsLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.BCEWithLogitsLoss.html) | [mindspore.nn.BCEWithLogitsLoss](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.BCEWithLogitsLoss.html) |    [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/BCEWithLogitsLoss.html)                                                           |
| [torch.nn.BatchNorm1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.BatchNorm1d.html) | [mindspore.nn.BatchNorm1d](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.BatchNorm1d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/BatchNorm1d.html) |
| [torch.nn.BatchNorm2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.BatchNorm2d.html) | [mindspore.nn.BatchNorm2d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.BatchNorm2d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/BatchNorm2d.html) |
| [torch.nn.BatchNorm3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.BatchNorm3d.html) | [mindspore.nn.BatchNorm3d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.BatchNorm3d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/BatchNorm3d.html) |
| [torch.nn.Bilinear](https://pytorch.org/docs/1.8.1/generated/torch.nn.Bilinear.html) | [mindspore.nn.BiDense](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.BiDense.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/BiDense.html) |
| [torch.nn.CeLU](https://pytorch.org/docs/1.8.1/generated/torch.nn.CELU.html) | [mindspore.nn.CELU](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.CELU.html) | 一致 |
| [torch.nn.ChannelShuffle](https://pytorch.org/docs/1.8.1/generated/torch.nn.ChannelShuffle.html) | [mindspore.nn.ChannelShuffle](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.ChannelShuffle.html) | 一致 |
|  [torch.nn.CTCLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.CTCLoss.html)  | [mindspore.nn.CTCLoss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.CTCLoss.html) |一致 |
| [torch.nn.ConstantPad1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ConstantPad1d.html)  | [mindspore.nn.ConstantPad1d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.ConstantPad1d.html) | 一致 |
| [torch.nn.ConstantPad2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ConstantPad2d.html)  | [mindspore.nn.ConstantPad2d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.ConstantPad2d.html) | 一致 |
| [torch.nn.ConstantPad3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ConstantPad3d.html)  | [mindspore.nn.ConstantPad3d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.ConstantPad3d.html) | 一致 |
| [torch.nn.Conv1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.Conv1d.html) | [mindspore.nn.Conv1d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Conv1d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/Conv1d.html)                                                             |
| [torch.nn.Conv2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.Conv2d.html) | [mindspore.nn.Conv2d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Conv2d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/Conv2d.html) |
| [torch.nn.Conv3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.Conv3d.html) | [mindspore.nn.Conv3d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Conv3d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/Conv3d.html)                                                             |
| [torch.nn.ConvTranspose1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ConvTranspose1d.html) | [mindspore.nn.Conv1dTranspose](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Conv1dTranspose.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/Conv1dTranspose.html)                                                             |
| [torch.nn.ConvTranspose2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ConvTranspose2d.html) | [mindspore.nn.Conv2dTranspose](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Conv2dTranspose.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/Conv2dTranspose.html)                                                             |
| [torch.nn.ConvTranspose3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ConvTranspose3d.html) | [mindspore.nn.Conv3dTranspose](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Conv3dTranspose.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/Conv3dTranspose.html)                                                             |
| [torch.nn.CosineEmbeddingLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.CosineEmbeddingLoss.html) | [mindspore.nn.CosineEmbeddingLoss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.CosineEmbeddingLoss.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/CosineEmbeddingLoss.html)                                                             |
| [torch.nn.CrossEntropyLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.CrossEntropyLoss.html) | [mindspore.nn.CrossEntropyLoss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.CrossEntropyLoss.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/CrossEntropyLoss.html)                                                             |
|  [torch.nn.Dropout](https://pytorch.org/docs/1.8.1/generated/torch.nn.Dropout.html) | [mindspore.nn.Dropout](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Dropout.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/Dropout.html) |
| [torch.nn.Dropout2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.Dropout2d.html#torch.nn.Dropout2d) | [mindspore.nn.Dropout2d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Dropout2d.html) | 一致 |
| [torch.nn.Dropout3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.Dropout3d.html#torch.nn.Dropout3d) | [mindspore.nn.Dropout3d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Dropout3d.html) | 一致
| [torch.nn.ELU](https://pytorch.org/docs/1.8.1/generated/torch.nn.ELU.html) | [mindspore.nn.ELU](https://www.mindspore.cn/docs/zh-CN/r2.0//api_python/nn/mindspore.nn.ELU.html) | 一致 |
| [torch.nn.GaussianNLLLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.GaussianNLLLoss.html)     | [mindspore.nn.GaussianNLLLoss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.GaussianNLLLoss.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/GaussianNLLLoss.html) |
| [torch.nn.GELU](https://pytorch.org/docs/1.8.1/generated/torch.nn.GELU.html) | [mindspore.nn.GELU](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.GELU.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/GELU.html)                                                             |
| [torch.nn.GRU](https://pytorch.org/docs/1.8.1/generated/torch.nn.GRU.html#torch.nn.GRU) | [mindspore.nn.GRU](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.GRU.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/GRU.html)                                                             |
| [torch.nn.GRUCell](https://pytorch.org/docs/1.8.1/generated/torch.nn.GRUCell.html) | [mindspore.nn.GRUCell](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.GRUCell.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/GRUCell.html)                                                             |
| [torch.nn.GroupNorm](https://pytorch.org/docs/1.8.1/generated/torch.nn.GroupNorm.html) | [mindspore.nn.GroupNorm](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.GroupNorm.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/GroupNorm.html)                                                             |
| [torch.nn.Hardshrink](https://pytorch.org/docs/1.8.1/generated/torch.nn.Hardshrink.html#torch.nn.Hardshrink) | [mindspore.nn.HShrink](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.HShrink.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/HShrink.html)                                                             |
| [torch.nn.Hardsigmoid](https://pytorch.org/docs/1.8.1/generated/torch.nn.Hardsigmoid.html) | [mindspore.nn.Hsigmoid](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.HSigmoid.html) | 一致 |
| [torch.nn.Hardswish](https://pytorch.org/docs/1.8.1/generated/torch.nn.Hardswish.html) | [mindspore.nn.Hswish](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.HSwish.html) | 一致 |
| [torch.nn.Hardtanh](https://pytorch.org/docs/1.8.1/generated/torch.nn.Hardtanh.html) | [mindspore.nn.Hardtanh](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Hardtanh.html) | 一致 |
| [torch.nn.HingeEmbeddingLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.HingeEmbeddingLoss.html) | [mindspore.nn.HingeEmbeddingLoss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.HingeEmbeddingLoss.html) | 一致|
| [torch.nn.Identity](https://pytorch.org/docs/1.8.1/generated/torch.nn.Identity.html) | [mindspore.nn.Identity](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Identity.html) | 功能一致，参数名不同|
| [torch.nn.init.uniform_](https://pytorch.org/docs/1.8.1/nn.init.html#torch.nn.init.uniform_)    | [mindspore.ops.uniform](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.uniform.html)                              | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/Uniform.html)           |
| [torch.nn.InstanceNorm1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.InstanceNorm1d.html) | [mindspore.nn.InstanceNorm1d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.InstanceNorm1d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/InstanceNorm1d.html)    |
| [torch.nn.InstanceNorm2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.InstanceNorm2d.html) | [mindspore.nn.InstanceNorm2d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.InstanceNorm2d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/InstanceNorm2d.html)|
| [torch.nn.InstanceNorm3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.InstanceNorm3d.html) | [mindspore.nn.InstanceNorm3d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.InstanceNorm3d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/InstanceNorm3d.html)|
| [torch.nn.KLDivLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.KLDivLoss.html)                   | [mindspore.nn.KLDivLoss](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.KLDivLoss.html)                      | 一致|
| [torch.nn.L1Loss](https://pytorch.org/docs/1.8.1/generated/torch.nn.L1Loss.html#torch.nn.L1Loss) | [mindspore.nn.L1Loss](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.L1Loss.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/L1Loss.html)                                                             |
| [torch.nn.LayerNorm](https://pytorch.org/docs/1.8.1/generated/torch.nn.LayerNorm.html) | [mindspore.nn.LayerNorm](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.LayerNorm.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/LayerNorm.html)      |
| [torch.nn.LeakyReLU](https://pytorch.org/docs/1.8.1/generated/torch.nn.LeakyReLU.html)| [mindspore.nn.LeakyReLU](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.LeakyReLU.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/LeakyReLU.html)     |
| [torch.nn.LPPool1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.LPPool1d.html)                   | [mindspore.nn.LPPool1d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.LPPool1d.html)                      | 一致|
| [torch.nn.LPPool2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.LPPool2d.html)                   | [mindspore.nn.LPPool2d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.LPPool2d.html)                      | 一致|
| [torch.nn.LSTM](https://pytorch.org/docs/1.8.1/generated/torch.nn.LSTM.html) | [mindspore.nn.LSTM](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.LSTM.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/LSTM.html)                                                             |
| [torch.nn.LSTMCell](https://pytorch.org/docs/1.8.1/generated/torch.nn.LSTMCell.html?torch.nn.LSTMCell) | [mindspore.nn.LSTMCell](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.LSTMCell.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/LSTMCell.html)                                                             |
| [torch.nn.Linear](https://pytorch.org/docs/1.8.1/generated/torch.nn.Linear.html) | [mindspore.nn.Dense](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Dense.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/Dense.html) |
| [torch.nn.LocalResponseNorm](https://pytorch.org/docs/1.8.1/generated/torch.nn.LocalResponseNorm.html) | [mindspore.ops.LRN](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.LRN.html) |[差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/LRN.html) |
| [torch.nn.LogSigmoid](https://pytorch.org/docs/1.8.1/generated/torch.nn.LogSigmoid.html) | [mindspore.nn.LogSigmoid](https://www.mindspore.cn/docs/en/r2.0/api_python/nn/mindspore.nn.LogSigmoid.html) | 一致 |
| [torch.nn.MSELoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.MSELoss.html) | [mindspore.nn.MSELoss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.MSELoss.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/MSELoss.html)                                                             |
| [torch.nn.MarginRankingLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.MarginRankingLoss.html) | [mindspore.nn.MarginRankingLoss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.MarginRankingLoss.html)    | 一致                 |
| [torch.nn.MaxPool1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.MaxPool1d.html) | [mindspore.nn.MaxPool1d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.MaxPool1d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/MaxPool1d.html) |
| [torch.nn.MaxPool2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.MaxPool2d.html) | [mindspore.nn.MaxPool2d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.MaxPool2d.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/MaxPool2d.html) |
| [torch.nn.MaxPool3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.MaxPool3d.html)                 | [mindspore.nn.MaxPool3d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.MaxPool3d.html)                    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/MaxPool3d.html)|
| [torch.nn.MaxUnpool1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.MaxUnpool1d.html)                 | [mindspore.nn.MaxUnpool1d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.MaxUnpool1d.html)                    | 一致|
| [torch.nn.MaxUnpool2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.MaxUnpool2d.html)                 | [mindspore.nn.MaxUnpool2d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.MaxUnpool2d.html)                    | 一致|
| [torch.nn.MaxUnpool3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.MaxUnpool3d.html)                 | [mindspore.nn.MaxUnpool3d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.MaxUnpool3d.html)                    | 一致|
| [torch.nn.MultiheadAttention](https://pytorch.org/docs/1.8.1/generated/torch.nn.MultiheadAttention.html)| [mindspore.nn.MultiheadAttention](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.MultiheadAttention.html)|一致|
| [torch.nn.MultiLabelSoftMarginLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.MultiLabelSoftMarginLoss.html) | [mindspore.nn.MultiLabelSoftMarginLoss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.MultiLabelSoftMarginLoss.html) | 一致 |
| [torch.nn.MultiMarginLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.MultiMarginLoss.html)| [mindspore.nn.MultiMarginLoss](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.MultiMarginLoss.html)|一致|
| [torch.nn.NLLLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.NLLLoss.html)                 | [mindspore.nn.NLLLoss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.NLLLoss.html)                    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/NLLLoss.html)  |
| [torch.nn.PReLU](https://pytorch.org/docs/1.8.1/generated/torch.nn.PReLU.html) | [mindspore.nn.PReLU](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.PReLU.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/PReLU.html)                                                             |
| [torch.nn.PixelShuffle](https://pytorch.org/docs/1.8.1/generated/torch.nn.PixelShuffle.html)                 | [mindspore.nn.PixelShuffle](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.PixelShuffle.html)                    | 一致|
| [torch.nn.PixelUnshuffle](https://pytorch.org/docs/1.8.1/generated/torch.nn.PixelUnshuffle.html)                 | [mindspore.nn.PixelUnshuffle](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.PixelUnshuffle.html)                    | 一致|
| [torch.nn.PoissonNLLLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.PoissonNLLLoss.html) | [mindspore.nn.PoissonNLLLoss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.PoissonNLLLoss.html) | 一致|
| [torch.nn.ReflectionPad1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ReflectionPad1d.html) | [mindspore.nn.ReflectionPad1d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.ReflectionPad1d.html) | 一致 |
| [torch.nn.ReflectionPad2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ReflectionPad2d.html) | [mindspore.nn.ReflectionPad2d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.ReflectionPad2d.html) | 一致 |
| [torch.nn.ReLU](https://pytorch.org/docs/1.8.1/generated/torch.nn.ReLU.html) | [mindspore.nn.ReLU](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.ReLU.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/ReLU.html)                                                             |
| [torch.nn.ReLU6](https://pytorch.org/docs/1.8.1/generated/torch.nn.ReLU6.html) | [mindspore.nn.ReLU6](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.ReLU6.html) | 一致|
| [torch.nn.ReplicationPad1d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ReplicationPad1d.html) | [mindspore.nn.ReplicationPad1d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.ReplicationPad1d.html) | 一致 |
| [torch.nn.ReplicationPad2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ReplicationPad2d.html) | [mindspore.nn.ReplicationPad2d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.ReplicationPad2d.html) | 一致 |
| [torch.nn.ReplicationPad3d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ReplicationPad3d.html) | [mindspore.nn.ReplicationPad3d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.ReplicationPad3d.html) | 一致 |
| [torch.nn.RNN](https://pytorch.org/docs/1.8.1/generated/torch.nn.RNN.html) | [mindspore.nn.RNN](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.RNN.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/RNN.html)                                                             |
| [torch.nn.RNNCell](https://pytorch.org/docs/1.8.1/generated/torch.nn.RNNCell.html) | [mindspore.nn.RNNCell](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.RNNCell.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/RNNCell.html)                                                             |
| [torch.nn.RReLU](https://pytorch.org/docs/1.8.1/generated/torch.nn.RReLU.html) | [mindspore.nn.RReLU](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.RReLU.html) | 一致|
| [torch.nn.SeLU](https://pytorch.org/docs/1.8.1/generated/torch.nn.SELU.html) | [mindspore.nn.SeLU](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.SeLU.html) | 一致 |
| [torch.nn.Sequential](https://pytorch.org/docs/1.8.1/generated/torch.nn.Sequential.html) | [mindspore.nn.SequentialCell](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.SequentialCell.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/SequentialCell.html)                                                             |
| [torch.nn.Sigmoid](https://pytorch.org/docs/1.8.1/generated/torch.nn.Sigmoid.html) | [mindspore.nn.Sigmoid](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Sigmoid.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/Sigmoid.html)                                                             |
| [torch.nn.SiLU](https://pytorch.org/docs/1.8.1/generated/torch.nn.SiLU.html) | [mindspore.nn.SiLU](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.SiLU.html) | 一致 |
| [torch.nn.SmoothL1Loss](https://pytorch.org/docs/1.8.1/generated/torch.nn.SmoothL1Loss.html) | [mindspore.nn.SmoothL1Loss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.SmoothL1Loss.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/SmoothL1Loss.html)                                                             |
| [torch.nn.SoftMarginLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.SoftMarginLoss.html) | [mindspore.nn.SoftMarginLoss](https://www.mindspore.cn/docs/en/r2.0/api_python/nn/mindspore.nn.SoftMarginLoss.html) |一致  |
| [torch.nn.Softmax](https://pytorch.org/docs/1.8.1/generated/torch.nn.Softmax.html) | [mindspore.nn.Softmax]( https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Softmax.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/nn_Softmax.html)                                                             |
| [torch.nn.Softmin](https://pytorch.org/docs/1.8.1/generated/torch.nn.Softmin.html) | [mindspore.nn.Softmin](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Softmin.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/softmin.html) |
| [torch.nn.Softmax2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.Softmax2d.html) | [mindspore.nn.Softmax2d]( https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Softmax2d.html) | 一致 |
| [torch.nn.Softshrink](https://pytorch.org/docs/1.8.1/generated/torch.nn.Softshrink.html) | [mindspore.nn.SoftShrink](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.SoftShrink.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/SoftShrink.html)                                                             |
| [torch.nn.Softsign](https://pytorch.org/docs/1.8.1/generated/torch.nn.Softsign.html) | [mindspore.nn.Softsign](https://www.mindspore.cn/docs/en/r2.0/api_python/nn/mindspore.nn.Softsign.html) | 一致 |
| [torch.nn.Tanh](https://pytorch.org/docs/1.8.1/generated/torch.nn.Tanh.html) | [mindspore.nn.Tanh](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Tanh.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/Tanh.html)                                                             |
| [torch.nn.Tanhshrink](https://pytorch.org/docs/1.8.1/generated/torch.nn.Tanhshrink.html) | [mindspore.nn.Tanhshrink](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Tanhshrink.html) | 一致 |
| [torch.nn.Threshold](https://pytorch.org/docs/1.8.1/generated/torch.nn.Threshold.html) | [mindspore.nn.Threshold](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Threshold.html) | 一致 |
| [torch.nn.Transformer](https://pytorch.org/docs/1.8.1/generated/torch.nn.Transformer.html)| [mindspore.nn.Transformer](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Transformer.html)|一致|
| [torch.nn.TransformerDecoder](https://pytorch.org/docs/1.8.1/generated/torch.nn.TransformerDecoder.html)| [mindspore.nn.TransformerDecoder](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.TransformerDecoder.html)|一致|
| [torch.nn.TransformerEncoder](https://pytorch.org/docs/1.8.1/generated/torch.nn.TransformerEncoder.html)| [mindspore.nn.TransformerEncoder](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.TransformerEncoder.html)|一致|
| [torch.nn.TransformerDecoderLayer](https://pytorch.org/docs/1.8.1/generated/torch.nn.TransformerDecoderLayer.html)| [mindspore.nn.TransformerDecoderLayer](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.TransformerDecoderLayer.html)|一致|
| [torch.nn.TransformerEncoderLayer](https://pytorch.org/docs/1.8.1/generated/torch.nn.TransformerEncoderLayer.html)| [mindspore.nn.TransformerEncoderLayer](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.TransformerEncoderLayer.html)|一致|
| [torch.nn.TripletMarginLoss](https://pytorch.org/docs/1.8.1/generated/torch.nn.TripletMarginLoss.html) | [mindspore.nn.TripletMarginLoss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.TripletMarginLoss.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/TripletMarginLoss.html) |
| [torch.nn.Unflatten](https://pytorch.org/docs/1.8.1/generated/torch.nn.Unflatten.html) | [mindspore.nn.Unflatten](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Unflatten.html) | 一致|
| [torch.nn.Unfold](https://pytorch.org/docs/1.8.1/generated/torch.nn.Unfold.html) | [mindspore.nn.Unfold](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Unfold.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/Unfold.html) |
| [torch.nn.Upsample](https://pytorch.org/docs/1.8.1/generated/torch.nn.Upsample.html#torch.nn.Upsample) | [mindspore.nn.Upsample](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Upsample.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/interpolate.html) |
| [torch.nn.ZeroPad2d](https://pytorch.org/docs/1.8.1/generated/torch.nn.ZeroPad2d.html) | [mindspore.nn.ZeroPad2d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.ZeroPad2d.html) | 一致 |

### torch.nn.functional

| PyTorch 1.8.1 APIs                                                                                                                       | MindSpore APIs                                                                                                                                                                                    | 说明                                                                                                                   |
| ---------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------- |
| [torch.nn.functional.adaptive_avg_pool2d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.adaptive_avg_pool2d)   | [mindspore.ops.adaptive_avg_pool2d](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.adaptive_avg_pool2d.html)                             | 一致 |
| [torch.nn.functional.adaptive_avg_pool3d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.adaptive_avg_pool3d)   | [mindspore.ops.adaptive_avg_pool3d](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.adaptive_avg_pool3d.html)                             | 一致 |
| [torch.nn.functional.adaptive_max_pool1d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.adaptive_max_pool1d)   | [mindspore.ops.adaptive_max_pool1d](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.adaptive_max_pool1d.html)                             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/AdaptiveMaxPool1d.html) |
| [torch.nn.functional.adaptive_max_pool2d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.adaptive_max_pool2d)   | [mindspore.ops.adaptive_max_pool2d](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.adaptive_max_pool2d.html)                             | 一致 |
| [torch.nn.functional.affine_grid](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.affine_grid)   | [mindspore.ops.affine_grid](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.affine_grid.html)                             | 一致 |
| [torch.nn.functional.avg_pool1d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.avg_pool1d)   | [mindspore.ops.avg_pool1d](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.avg_pool1d.html)                             | 功能一致，参数名不同|
| [torch.nn.functional.avg_pool2d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.avg_pool2d)   | [mindspore.ops.avg_pool2d](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.avg_pool2d.html)                             | 功能一致，参数名不同|
| [torch.nn.functional.avg_pool3d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.avg_pool3d)   | [mindspore.ops.avg_pool3d](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.avg_pool3d.html)                             | 功能一致，参数名不同|
| [torch.nn.functional.batch_norm](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.batch_norm)   | [mindspore.ops.batch_norm](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.batch_norm.html)                             | 一致|
| [torch.nn.functional.binary_cross_entropy](https://pytorch.org/docs/1.8.1/nn.functional.html#binary-cross-entropy)   | [mindspore.ops.binary_cross_entropy](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.binary_cross_entropy.html)                             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/binary_cross_entropy.html)     |
| [torch.nn.functional.binary_cross_entropy_with_logits](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.binary_cross_entropy_with_logits)   | [mindspore.ops.binary_cross_entropy_with_logits](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.binary_cross_entropy_with_logits.html)                             | [功能一致，默认值不同](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/bce_with_logits.html)                |
| [torch.nn.functional.conv1d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.conv1d) | [mindspore.ops.conv1d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.conv1d.html) | 一致 |
| [torch.nn.functional.conv2d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.conv2d) | [mindspore.ops.conv2d](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.conv2d.html) | 一致 |
| [torch.nn.functional.conv3d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.conv3d) | [mindspore.ops.conv3d](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.conv3d.html) | 一致 |
| [torch.nn.functional.cosine_embedding_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.cosine_embedding_loss) | [mindspore.ops.cosine_embedding_loss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.cosine_embedding_loss.html) |  一致 |
| [torch.nn.functional.cosine_similarity](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.cosine_similarity)| [mindspore.ops.cosine_similarity](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.cosine_similarity.html)|一致|
| [torch.nn.functional.cross_entropy](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.cross_entropy)| [mindspore.ops.cross_entropy](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.cross_entropy.html)|一致|
| [torch.nn.functional.ctc_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.ctc_loss)| [mindspore.ops.ctc_loss](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.ctc_loss.html)|一致|
| [torch.nn.functional.dropout](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.dropout) | [mindspore.ops.dropout](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.dropout.html#mindspore.ops.dropout) | 一致 |
| [torch.nn.functional.dropout2d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.dropout2d) | [mindspore.ops.dropout2d](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.dropout2d.html#mindspore.ops.dropout2d) | [功能一致，数据类型不同](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/dropout2d.html) |
| [torch.nn.functional.dropout3d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.dropout3d) | [mindspore.ops.dropout3d](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.dropout3d.html#mindspore.ops.dropout3d) | [功能一致，数据类型不同](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/dropout3d.html) |
| [torch.nn.functional.elu](https://pytorch.org/docs/1.8.1/nn.functional.html#elu)                                     | [mindspore.ops.elu](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.elu.html)                                                                           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/elu.html)                                                                                                                       |
| [torch.nn.functional.fold](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.fold) | [mindspore.ops.fold](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.fold.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/mindspore.ops.fold.html) |
| [torch.nn.functional.gelu](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.gelu) | [mindspore.ops.gelu](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.gelu.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/mindspore.ops.gelu.html) |
| [torch.nn.functional.glu](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.glu) | [mindspore.ops.glu](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.glu.html) | 功能一致，参数名不同 |
| [torch.nn.functional.grid_sample](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.grid_sample) | [mindspore.ops.grid_sample](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.grid_sample.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/mindspore.ops.grid_sample.html) |
| [torch.nn.functional.gumbel_softmax](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.gumbel_softmax) | [mindspore.ops.gumbel_softmax](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.gumbel_softmax.html) | 一致  |
| [torch.nn.functional.hardshrink](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.hardshrink) | [mindspore.ops.hardshrink](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.hardshrink.html) | 功能一致，参数名不同 |
| [torch.nn.functional.hardsigmoid](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.hardsigmoid) | [mindspore.ops.hardsigmoid](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.hardsigmoid.html) | 一致 |
| [torch.nn.functional.hardswish](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.hardswish) | [mindspore.ops.hardswish](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.hardswish.html) | 功能一致，参数名不同 |
| [torch.nn.functional.hardtanh](https://pytorch.org/docs/1.8.1/nn.functional.html#hardtanh)   | [mindspore.ops.hardtanh](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.hardtanh.html)     | 一致 |
| [torch.nn.functional.hinge_embedding_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#hinge-embedding-loss) | [mindspore.ops.hinge_embedding_loss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.hinge_embedding_loss.html) |  一致 |
| [torch.nn.functional.interpolate](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.interpolate)                                     | [mindspore.ops.interpolate](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.interpolate.html)                                                                           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/interpolate.html)                                                                                                                       |
| [torch.nn.functional.kl_div](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.kl_div)                             | [mindspore.ops.kl_div](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.kl_div.html#mindspore.ops.kl_div)  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/kl_div.html) |
| [torch.nn.functional.l1_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#l1-loss)                             | [mindspore.ops.l1_loss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.l1_loss.html#mindspore.ops.l1_loss)  | 一致 |
| [torch.nn.functional.leaky_relu](https://pytorch.org/docs/1.8.1/nn.functional.html#leaky-relu)                             | [mindspore.ops.leaky_relu](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.leaky_relu.html#mindspore.ops.leaky_relu)   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/leaky_relu.html) |
| [torch.nn.functional.logsigmoid](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.logsigmoid) | [mindspore.ops.logsigmoid](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.logsigmoid.html) |  功能一致，参数名不同  |
| [torch.nn.functional.log_softmax](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.log_softmax) | [mindspore.ops.log_softmax](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.log_softmax.html) |   [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/log_softmax.html)                                                            |
| [torch.nn.functional.lp_pool1d](https://pytorch.org/docs/1.8.1/nn.functional.html#lp-pool1d)                     | [mindspore.ops.lp_pool1d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.lp_pool1d.html)           | 功能一致，参数名不同|
| [torch.nn.functional.lp_pool2d](https://pytorch.org/docs/1.8.1/nn.functional.html#lp-pool2d)                     | [mindspore.ops.lp_pool2d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.lp_pool2d.html)           | 功能一致，参数名不同|
| [torch.nn.functional.margin_ranking_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#margin-ranking-loss) | [mindspore.ops.margin_ranking_loss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.margin_ranking_loss.html) | 一致|
| [torch.nn.functional.max_pool3d](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.max_pool3d) | [mindspore.ops.max_pool3d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.max_pool3d.html) | 一致|
| [torch.nn.functional.max_unpool1d](https://pytorch.org/docs/1.8.1/nn.functional.html#max-unpool1d) | [mindspore.ops.max_unpool1d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.max_unpool1d.html) | 一致|
| [torch.nn.functional.max_unpool2d](https://pytorch.org/docs/1.8.1/nn.functional.html#max-unpool2d) | [mindspore.ops.max_unpool2d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.max_unpool2d.html) | 一致|
| [torch.nn.functional.max_unpool3d](https://pytorch.org/docs/1.8.1/nn.functional.html#max-unpool3d) | [mindspore.ops.max_unpool3d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.max_unpool3d.html) | 一致|
| [torch.nn.functional.mse_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#mse-loss)                           | [mindspore.ops.mse_loss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.mse_loss.html)            | 一致|
| [torch.nn.functional.multi_margin_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.multi_margin_loss) | [mindspore.ops.multi_margin_loss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.multi_margin_loss.html) | 一致 |
| [torch.nn.functional.multilabel_margin_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.multilabel_margin_loss) | [mindspore.ops.multilabel_margin_loss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.multilabel_margin_loss.html) | 一致 |
| [torch.nn.functional.multilabel_soft_margin_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.multilabel_soft_margin_loss) | [mindspore.ops.multilabel_soft_margin_loss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.multilabel_soft_margin_loss.html) | 一致 |
| [torch.nn.functional.nll_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.nll_loss) | [mindspore.ops.nll_loss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.nll_loss.html) | 一致 |
| [torch.nn.functional.pad](https://pytorch.org/docs/1.8.1/nn.functional.html#pad) | [mindspore.ops.pad](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.pad.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/pad.html) |
| [torch.nn.functional.pdist](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.pdist) | [mindspore.ops.pdist](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.pdist.html) |  一致  |
| [torch.nn.functional.pixel_shuffle](https://pytorch.org/docs/1.8.1/nn.functional.html#pixel-shuffle) | [mindspore.ops.pixel_shuffle](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.pixel_shuffle.html) | 一致 |
| [torch.nn.functional.pixel_unshuffle](https://pytorch.org/docs/1.8.1/nn.functional.html#pixel-unshuffle) | [mindspore.ops.pixel_unshuffle](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.pixel_unshuffle.html) | 一致 |
| [torch.nn.functional.prelu](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.prelu) | [mindspore.ops.prelu](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.prelu.html) | 功能一致，参数名不同 |
| [torch.nn.functional.relu](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.relu) | [mindspore.ops.relu](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.relu.html) |  功能一致，参数名不同  |
| [torch.nn.functional.relu6](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.relu6) | [mindspore.ops.relu6](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.relu6.html) | 功能一致，参数名不同 |
| [torch.nn.functional.rrelu](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.rrelu) | [mindspore.ops.rrelu](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.rrelu.html) |  功能一致，参数名不同  |
| [torch.nn.functional.selu](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.selu) | [mindspore.ops.selu](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.selu.html) | 功能一致，参数名不同 |
| [torch.nn.functional.sigmoid](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.sigmoid) | [mindspore.ops.sigmoid](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.sigmoid.html) | 功能一致，参数名不同 |
| [torch.nn.functional.silu](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.silu) | [mindspore.ops.silu](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.silu.html) |  功能一致，参数名不同  |
| [torch.nn.functional.softmax](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.softmax) | [mindspore.ops.softmax](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.softmax.html#mindspore.ops.softmax) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/softmax.html) |
| [torch.nn.functional.softmin](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.softmin) | [mindspore.ops.softmin](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.softmin.html#mindspore.ops.softmin) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/softmin.html) |
| [torch.nn.functional.softsign](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.softsign) | [mindspore.ops.softsign](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.softsign.html) | 功能一致，参数名不同 |
| [torch.nn.functional.smooth_l1_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.smooth_l1_loss)           | [mindspore.ops.smooth_l1_loss](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.smooth_l1_loss.html)                                              | 一致  |
| [torch.nn.functional.soft_margin_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#soft-margin-loss)           | [mindspore.nn.SoftMarginLoss](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.SoftMarginLoss.html)                                              | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/SoftMarginLoss.html)                                                                                                                       |
| [torch.nn.functional.softshrink](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.softshrink) | [mindspore.ops.softshrink](https://www.mindspore.cn/docs/zh-CN/master/api_python/ops/mindspore.ops.softshrink.html) |  功能一致，参数名不同 |
| [torch.nn.functional.tanh](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.tanh) | [mindspore.ops.tanh](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.tanh.html) | 功能一致，参数名不同 |
| [torch.nn.functional.tanhshrink](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.tanhshrink) | [mindspore.ops.tanhshrink](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.tanhshrink.html) | 一致 |
| [torch.nn.functional.threshold](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.threshold) | [mindspore.ops.threshold](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.threshold.html) | 功能一致，参数名不同 |
| [torch.nn.functional.triplet_margin_loss](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.triplet_margin_loss) | [mindspore.ops.triplet_margin_loss](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.triplet_margin_loss.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/TripletMarginLoss.html) |
| [torch.nn.functional.upsample](https://pytorch.org/docs/1.8.1/nn.functional.html#torch.nn.functional.upsample) | [mindspore.ops.upsample](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.upsample.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/interpolate.html) |

### torch.nn.Module

| PyTorch 1.8.1 APIs                                                                                                                       | MindSpore APIs                                                                                                                                                                                    | 说明                                                                                                                   |
| ---------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------- |
| [torch.nn.Module.apply](https://pytorch.org/docs/1.8.1/generated/torch.nn.Module.html#torch.nn.Module.apply) | [mindspore.nn.Cell.apply](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.Cell.html#mindspore.nn.Cell.apply) |         一致        |

### torch.nn.utils

| PyTorch 1.8.1 APIs                                                                                                                       | MindSpore APIs                                                                                                                                                                                    | 说明                                                                                                                   |
| ---------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------- |
|[torch.nn.utils.clip_grad_value_](https://pytorch.org/docs/1.8.1/generated/torch.nn.utils.clip_grad_value_.html)                   |[mindspore.ops.clip_by_value](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.clip_by_value.html)                           |             [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/clip_by_value.html)        |

### torch.Tensor

| PyTorch 1.8.1 APIs                                                                                           | MindSpore APIs                                                                                                                                       | 说明                                         |
|--------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------|
| [torch.Tensor.abs](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.abs)                              | [mindspore.Tensor.abs](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.abs.html)                       |   一致|
| [torch.Tensor.absolute](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.absolute)  | [mindspore.Tensor.absolute](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.absolute.html)  |   一致|
| [torch.Tensor.acos](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.acos)| [mindspore.Tensor.acos](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.acos.html)|一致|
| [torch.Tensor.acosh](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.acosh)| [mindspore.Tensor.acosh](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.acosh.html)|一致|
| [torch.Tensor.add](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.add)| [mindspore.Tensor.add](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.add.html)|一致|
| [torch.Tensor.addbmm](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.addbmm)                              | [mindspore.Tensor.addbmm](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.addbmm.html)                       |   一致|
| [torch.Tensor.addcdiv](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.addcdiv)| [mindspore.Tensor.addcdiv](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.addcdiv.html)|一致|
| [torch.Tensor.addcmul](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.addcmul)| [mindspore.Tensor.addcmul](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.addcmul.html)|一致|
| [torch.Tensor.addmm](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.addmm)                                | [mindspore.Tensor.addmm](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.addmm.html)                         |   一致|
| [torch.Tensor.addmv](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.addmv)                                | [mindspore.Tensor.addmv](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.addmv.html)                         |   功能一致，参数名不同 |
| [torch.Tensor.addr](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.addr) | [mindspore.Tensor.addr](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.addr.html) | 一致 |
| [torch.Tensor.all](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.all)                                | [mindspore.Tensor.all](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.all.html)                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/all.html) |
| [torch.Tensor.amax](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.amax)                                | [mindspore.Tensor.amax](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.amax.html)                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/amax.html) |
| [torch.Tensor.amin](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.amin)                                | [mindspore.Tensor.amin](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.amin.html)                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/amin.html) |
| [torch.Tensor.any](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.any)                                | [mindspore.Tensor.any](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.any.html)                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/any.html) |
| [torch.Tensor.arccos](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.arccos)                     | [mindspore.Tensor.arccos](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.arccos.html)         | 一致                    |
| [torch.Tensor.arccosh](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.arccosh)                     | [mindspore.Tensor.arccosh](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.arccosh.html)         | 一致                    |
| [torch.Tensor.argmax](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.argmax)                 | [mindspore.Tensor.argmax](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.argmax.html#mindspore.Tensor.argmax)                       | 功能一致，参数名不同 |
| [torch.Tensor.angle](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.angle)                     | [mindspore.Tensor.angle](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.angle.html)                     | 一致                                       |
| [torch.Tensor.arcsin](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.arcsin)                     | [mindspore.Tensor.arcsin](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.arcsin.html)                     | 一致                                       |
| [torch.Tensor.arcsinh](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.arcsinh)                     | [mindspore.Tensor.arcsinh](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.arcsinh.html)                     | 一致                                       |
| [torch.Tensor.arctan](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.arctan)                     | [mindspore.Tensor.arctan](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.arctan.html)                     | 一致                                       |
| [torch.Tensor.arctanh](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.arctanh)                     | [mindspore.Tensor.arctanh](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.arctanh.html)                     | 一致                                       |
| [torch.Tensor.argmin](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.argmin)  | [mindspore.Tensor.argmin](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.argmin.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/argmin.html) |
| [torch.Tensor.argsort](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.argsort)                     | [mindspore.Tensor.argsort](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.argsort.html)                     | 一致                                       |
| [torch.Tensor.asin](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.asin)| [mindspore.Tensor.asin](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.asin.html)|一致|
| [torch.Tensor.asinh](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.asinh)| [mindspore.Tensor.asinh](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.asinh.html)|一致|
| [torch.Tensor.atan](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.atan)| [mindspore.Tensor.atan](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.atan.html)|一致|
| [torch.Tensor.atan2](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.atan2)                     | [mindspore.Tensor.atan2](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.atan2.html)                     | 一致 |
| [torch.Tensor.atanh](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.atanh)| [mindspore.Tensor.atanh](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.atanh.html)|一致|
| [torch.Tensor.baddbmm](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.baddbmm)                     | [mindspore.Tensor.baddbmm](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.baddbmm.html)                     | 一致   |
| [torch.Tensor.bernoulli](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.bernoulli) | [mindspore.Tensor.bernoulli](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.bernoulli.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/bernoulli.html) |
| [torch.Tensor.bincount](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.bincount)                     | [mindspore.Tensor.bincount](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.bincount.html)                     | 一致                                       |
| [torch.Tensor.bitwise_and](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.bitwise_and)| [mindspore.Tensor.bitwise_and](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.bitwise_and.html)|一致|
| [torch.Tensor.bitwise_or](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.bitwise_or)| [mindspore.Tensor.bitwise_or](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.bitwise_or.html)|一致|
| [torch.Tensor.bitwise_xor](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.bitwise_xor)| [mindspore.Tensor.bitwise_xor](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.bitwise_xor.html)|一致|
| [torch.Tensor.bmm](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.bmm)| [mindspore.Tensor.bmm](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.bmm.html)| 功能一致，参数名不同 |
| [torch.Tensor.bool](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.bool)| [mindspore.Tensor.bool](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.bool.html)| 功能一致，参数名不同 |
| [torch.Tensor.broadcast_to](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.broadcast_to) | [mindspore.Tensor.broadcast_to](https://mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.broadcast_to.html)                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/broadcast_to.html)        |
| [torch.Tensor.ceil](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.ceil)                     | [mindspore.Tensor.ceil](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.ceil.html)                     | 一致                                       |
| [torch.Tensor.chunk](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.chunk)                     | [mindspore.Tensor.chunk](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.chunk.html)                     | 一致                                       |
| [torch.Tensor.cholesky](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.cholesky) | [mindspore.Tensor.cholesky](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.cholesky.html) | 一致 |
| [torch.Tensor.clamp](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.clamp)                         | [mindspore.Tensor.clamp](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.clamp.html)                         |    一致    |
| [torch.Tensor.clip](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.clip)                           | [mindspore.Tensor.clip](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.clip.html)                           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/clip.html)     |
| [torch.Tensor.conj](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.conj)                   | [mindspore.Tensor.conj](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.conj.html)                   | 一致                                       |
| [torch.Tensor.copysign](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.copysign)                   | [mindspore.Tensor.copysign](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.copysign.html)                   | 一致                                       |
| [torch.Tensor.cos](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.cos)                     | [mindspore.Tensor.cos](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.cos.html)                     | 一致                                       |
| [torch.Tensor.cosh](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.cosh)                     | [mindspore.Tensor.cosh](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.cosh.html)                     | 一致                                       |
| [torch.Tensor.cross](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.cross)                     | [mindspore.Tensor.cross](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.cross.html)                     | 一致      |
| [torch.Tensor.cummax](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.cummax)                       | [mindspore.Tensor.cummax](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.cummax.html)                       | 功能一致，参数名不同                              |
| [torch.Tensor.cummin](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.cummin)                       | [mindspore.Tensor.cummin](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.cummin.html)                       | 功能一致，参数名不同      |
| [torch.Tensor.cumprod](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.cumprod) | [mindspore.Tensor.cumprod](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.cumprod.html) | 一致 |
| [torch.Tensor.cumsum](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.cumsum) | [mindspore.Tensor.cumsum](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.cumsum.html) | 一致 |
| [torch.Tensor.deg2rad](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.deg2rad)                     | [mindspore.Tensor.deg2rad](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.deg2rad.html)                     | 一致                                       |
| [torch.Tensor.diag](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.diag)                       |   [mindspore.Tensor.diag](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.diag.html))                                       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/diag.html) |
| [torch.Tensor.diagflat](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.diagflat)                     | [mindspore.Tensor.diagflat](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.diagflat.html)                     | 一致                                       |
| [torch.Tensor.diff](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.diff)                     | [mindspore.Tensor.diff](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.diff.html)                     | 功能一致，参数名不同 |
| [torch.Tensor.digamma](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.digamma)                     | [mindspore.Tensor.digamma](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.digamma.html)                     | 一致                                       |
| [torch.Tensor.dim](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.dim) | [mindspore.Tensor.ndimension](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.ndimension.html) | 一致 |
| [torch.Tensor.div](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.div)                     | [mindspore.Tensor.div](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.div.html)                     | 功能一致，参数名不同                |
| [torch.Tensor.divide](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.divide)                     | [mindspore.Tensor.divide](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.divide.html)                     | 一致                                       |
| [torch.Tensor.equal](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.equal)                              | [mindspore.Tensor.equal](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.equal.html)                       | 一致 |
| [torch.Tensor.erf](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.erf)                              | [mindspore.Tensor.erf](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.erf.html)                       |   一致|
| [torch.Tensor.erfc](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.erfc)                              | [mindspore.Tensor.erfc](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.erfc.html)                       |   一致|
| [torch.Tensor.erfinv](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.erfinv)                              | [mindspore.Tensor.erfinv](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.erfinv.html)                       |   一致|
| [torch.Tensor.exp](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.exp)                              | [mindspore.Tensor.exp](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.exp.html)                       |   一致|
| [torch.Tensor.expand_as](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.expand_as)           | [mindspore.Tensor.expand_as](https://mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.expand_as.html#mindspore.Tensor.expand_as) | 功能一致，参数名不同 |
| [torch.Tensor.expm1](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.expm1)                              | [mindspore.Tensor.expm1](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.expm1.html)                       |   一致|
| [torch.Tensor.flip](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.flip)                           | [mindspore.Tensor.flip](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.flip.html)                           | 一致                                       |
| [torch.Tensor.fliplr](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.fliplr)                       | [mindspore.Tensor.fliplr](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.fliplr.html)                       | 一致                                       |
| [torch.Tensor.flipud](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.flipud)                       | [mindspore.Tensor.flipud](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.flipud.html)                       | 一致                                       |
| [torch.Tensor.float](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.float)                       | [mindspore.Tensor.float](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.float.html)                       | 功能一致，参数名不同         |
| [torch.Tensor.float_power](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.float_power)                       | [mindspore.Tensor.float_power](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.float_power.html)                       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/float_power.html)                                       |
| [torch.Tensor.floor](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.floor)                       | [mindspore.Tensor.floor](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.floor.html)                       | 一致                                       |
| [torch.Tensor.fmod](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.fmod)                       | [mindspore.Tensor.fmod](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.fmod.html)                                   | 一致|
| [torch.Tensor.frac](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.frac)                       | [mindspore.Tensor.frac](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.frac.html)                                   | 功能一致，参数名不同 |
| [torch.Tensor.gather](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.gather)                       | [mindspore.Tensor.gather_elements](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.gather_elements.html) | 一致 |
| [torch.Tensor.ge](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.ge)                       | [mindspore.Tensor.ge](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.ge.html) | 功能一致，参数名不同 |
| [torch.Tensor.geqrf](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.geqrf)                       | [mindspore.Tensor.geqrf](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.geqrf.html) | 一致 |
| [torch.Tensor.ger](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.ger) | [mindspore.Tensor.ger](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.ger.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/ger.html) |
| [torch.Tensor.greater](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.greater)                       | [mindspore.Tensor.greater](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.greater.html) | 功能一致，参数名不同 |
| [torch.Tensor.greater_equal](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.greater_equal)                       | [mindspore.Tensor.greater_equal](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.greater_equal.html) | 功能一致，参数名不同 |
| [torch.Tensor.gt](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.gt)                       | [mindspore.Tensor.gt](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.gt.html) | 功能一致，参数名不同 |
| [torch.Tensor.H](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.H)                       | [mindspore.Tensor.H](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.H.html)                       | 一致                                       |
| [torch.Tensor.half](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.half)                       | [mindspore.Tensor.half](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.half.html)                       | 功能一致，参数名不同                 |
| [torch.Tensor.hardshrink](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.hardshrink) | [mindspore.Tensor.hardshrink](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.hardshrink.html) | 一致 |
| [torch.Tensor.heaviside](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.heaviside)                       | [mindspore.Tensor.heaviside](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.heaviside.html)                       | 一致                                       |
| [torch.Tensor.histc](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.histc)                       | [mindspore.Tensor.histc](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.histc.html)                       | 一致                                       |
| [torch.Tensor.hypot](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.hypot)                       | [mindspore.Tensor.hypot](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.hypot.html)                       | 一致                                       |
| [torch.Tensor.i0](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.i0) | [mindspore.Tensor.i0](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.i0.html) | 一致                                       |
| [torch.Tensor.igamma](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.igamma)| [mindspore.Tensor.igamma](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.igamma.html)|一致|
| [torch.Tensor.igammac](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.igammac)| [mindspore.Tensor.igammac](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.igammac.html)|一致|
| [torch.Tensor.imag](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.imag)| [mindspore.Tensor.imag](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.imag.html)|一致|
| [torch.Tensor.index_add](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.index_add)           | [mindspore.Tensor.index_add](https://mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.index_add.html) | 功能一致，参数名不同 |
| [torch.Tensor.index_fill](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.index_fill) | [mindspore.Tensor.index_fill](https://mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.index_fill.html) | 一致 |
| [torch.Tensor.index_select](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.index_select)           | [mindspore.Tensor.index_select](https://mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.index_select.html) | 功能一致，参数名不同 |
| [torch.Tensor.inner](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.inner)      | [mindspore.Tensor.inner](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.inner.html)    | 功能一致，参数名不同 |
| [torch.Tensor.int](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.int)      | [mindspore.Tensor.int](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.int.html)    | 功能一致，参数名不同 |
| [torch.Tensor.inverse](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.inverse)                 | [mindspore.Tensor.inverse](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.inverse.html)                 | 一致 |
| [torch.Tensor.isclose](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.isclose)      | [mindspore.Tensor.isclose](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.isclose.html)    | 功能一致，参数名不同 |
| [torch.Tensor.isfinite](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.isfinite)      | [mindspore.Tensor.isfinite](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.isfinite.html)    | 一致 |
| [torch.Tensor.isinf](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.isinf)      | [mindspore.Tensor.isinf](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.isinf.html)    | 一致 |
| [torch.Tensor.isnan](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.isnan)      | [mindspore.Tensor.isnan](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.isnan.html)    | 一致 |
| [torch.Tensor.is_complex](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.is_complex) | [mindspore.Tensor.is_complex](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.is_complex.html) | 一致                                       |
| [torch.Tensor.is_floating_point](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.is_floating_point) | [mindspore.Tensor.is_floating_point](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.is_floating_point.html) | 一致                                       |
| [torch.Tensor.is_signed](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.is_signed)                 | [mindspore.Tensor.is_signed](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.is_signed.html)                 | 一致                                       |
| [torch.Tensor.isneginf](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.isneginf)                 | [mindspore.Tensor.isneginf](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.isneginf.html)                 | 一致 |
| [torch.Tensor.isposinf](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.isposinf)                 | [mindspore.Tensor.isposinf](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.isposinf.html)                 | 一致 |
| [torch.Tensor.isreal](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.isreal)                 | [mindspore.Tensor.isreal](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.isreal.html)                 | 一致 |
| [torch.Tensor.item](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.item) | [mindspore.Tensor.item](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.item.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/item.html) |
| [torch.Tensor.lcm](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.lcm)                             | [mindspore.Tensor.lcm](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.lcm.html)      | 一致                                       |
| [torch.Tensor.ldexp](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.ldexp)                         | [mindspore.Tensor.ldexp](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.ldexp.html)      | 一致                                       |
| [torch.Tensor.le](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.le)                 | [mindspore.Tensor.le](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.le.html)                 | 功能一致，参数名不同 |
| [torch.Tensor.lerp](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.lerp)                         | [mindspore.Tensor.lerp](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.lerp.html)                         | 一致                                       |
| [torch.Tensor.less](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.less)                 | [mindspore.Tensor.less](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.less.html)                 | 功能一致，参数名不同 |
| [torch.Tensor.less_equal](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.less_equal)                 | [mindspore.Tensor.less_equal](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.less_equal.html)                 | 功能一致，参数名不同 |
| [torch.Tensor.log](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.log)                   | [mindspore.Tensor.log](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.log.html)                 | 一致                                       |
| [torch.Tensor.log10](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.log10)                   | [mindspore.Tensor.log10](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.log10.html)                 | 一致                                       |
| [torch.Tensor.log1p](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.log1p)                   | [mindspore.Tensor.log1p](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.log1p.html)                 | 一致                                       |
| [torch.Tensor.log2](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.log2)                   | [mindspore.Tensor.log2](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.log2.html)                 | 一致                                       |
| [torch.Tensor.logaddexp](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.logaddexp)                   | [mindspore.Tensor.logaddexp](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.logaddexp.html)                 | 一致                                       |
| [torch.Tensor.logaddexp2](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.logaddexp2)                   | [mindspore.Tensor.logaddexp2](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.logaddexp2.html)                 | 一致                                       |
| [torch.Tensor.logdet](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.logdet) | [mindspore.Tensor.logdet](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.logdet.html) | 一致 |
| [torch.Tensor.logical_and](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.logical_and) | [mindspore.Tensor.logical_and](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.logical_and.html) | 一致 |
| [torch.Tensor.logical_not](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.logical_not) | [mindspore.Tensor.logical_not](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.logical_not.html) | 一致 |
| [torch.Tensor.logical_or](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.logical_or) | [mindspore.Tensor.logical_or](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.logical_or.html) | 一致 |
| [torch.Tensor.logical_xor](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.logical_xor) | [mindspore.Tensor.logical_xor](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.logical_xor.html) | 一致 |
| [torch.Tensor.logit](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.logit)| [mindspore.Tensor.logit](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.logit.html)|功能一致，参数名不同|
| [torch.Tensor.logsumexp](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.logsumexp)                   | [mindspore.Tensor.logsumexp](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.logsumexp.html)                 | 一致                                       |
| [torch.Tensor.long](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.long)                   | [mindspore.Tensor.long](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.long.html)                 | 功能一致，参数名不同                                       |
| [torch.Tensor.lt](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.lt)                   | [mindspore.Tensor.lt](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.lt.html)                 | 一致                                       |
| [torch.Tensor.masked_fill](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.masked_fill) | [mindspore.Tensor.masked_fill](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.masked_fill.html) | 一致 |
| [torch.Tensor.masked_select](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.masked_select) | [mindspore.Tensor.masked_select](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.masked_select.html) | 一致 |
| [torch.Tensor.matmul](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.matmul) | [mindspore.Tensor.matmul](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.matmul.html) | 一致 |
| [torch.Tensor.max](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.max)                       | [mindspore.Tensor.max](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.max.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/tensor_max.html) |
| [torch.Tensor.maximum](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.maximum) | [mindspore.Tensor.maximum](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.maximum.html) | 功能一致，参数名不同 |
| [torch.Tensor.mean](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.mean) | [mindspore.Tensor.mean](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.mean.html) | 功能一致，参数名不同 |
| [torch.Tensor.median](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.median) | [mindspore.Tensor.median](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.median.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/median.html) |
| [torch.Tensor.mH](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.mH)| [mindspore.Tensor.mH](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.mH.html)|一致|
| [torch.Tensor.min](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.min) | [mindspore.Tensor.min](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.min.html#mindspore.Tensor.min) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/tensor_min.html) |
| [torch.Tensor.minimum](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.minimum) | [mindspore.Tensor.minimum](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.minimum.html) | 功能一致，参数名不同 |
| [torch.Tensor.mm](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.mm)| [mindspore.Tensor.mm](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.mm.html)|一致|
| [torch.Tensor.moveaxis](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.moveaxis) | [mindspore.Tensor.moveaxis](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.moveaxis.html) | 功能一致 |
| [torch.Tensor.movedim](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.movedim) | [mindspore.Tensor.movedim](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.movedim.html) | 一致 |
| [torch.Tensor.msort](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.msort) | [mindspore.Tensor.msort](https://www.mindspore.cn/docs/en/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.msort.html) | 一致  |
| [torch.Tensor.mT](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.mT)| [mindspore.Tensor.mT](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.mT.html)|一致|
| [torch.Tensor.mul](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.mul) | [mindspore.Tensor.mul](https://www.mindspore.cn/docs/en/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.mul.html) | 一致|
| [torch.Tensor.multinomial](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.multinomial) | [mindspore.Tensor.multinomial](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.multinomial.html#mindspore.Tensor.multinomial) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/multinomial.html) |
| [torch.Tensor.multiply](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.multiply) | [mindspore.Tensor.multiply](https://www.mindspore.cn/docs/en/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.multiply.html) | 一致|
| [torch.Tensor.mvlgamma](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.mvlgamma) | [mindspore.Tensor.mvlgamma](https://www.mindspore.cn/docs/en/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.mvlgamma.html) | 一致|
| [torch.Tensor.nan_to_num](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.nan_to_num) | [mindspore.Tensor.nan_to_num](https://www.mindspore.cn/docs/en/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.nan_to_num.html) | 功能一致，数据类型不同|
| [torch.Tensor.nansum](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.nansum) | [mindspore.Tensor.nansum](https://www.mindspore.cn/docs/en/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.nansum.html) | 一致 |
| [torch.Tensor.narrow](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.narrow) | [mindspore.Tensor.narrow](https://www.mindspore.cn/docs/en/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.narrow.html) | 一致 |
| [torch.Tensor.ndim](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.ndim) | [mindspore.Tensor.ndim](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.ndim.html) | 一致 |
| [torch.Tensor.ndimension](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.ndimension) | [mindspore.Tensor.ndimension](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.ndimension.html) | 一致 |
| [torch.Tensor.ne](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.ne) | [mindspore.Tensor.ne](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.ne.html) | 一致，参数名不同 |
| [torch.Tensor.neg](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.neg)                   | [mindspore.Tensor.neg](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.neg.html)                 | 一致                                       |
| [torch.Tensor.negative](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.negative)                   | [mindspore.Tensor.negative](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.negative.html)                 | 一致                                       |
| [torch.Tensor.nelement](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.nelement)                   | [mindspore.Tensor.nelement](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.nelement.html)                 | 一致                                       |
| [torch.Tensor.new_ones](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.new_ones) | [mindspore.Tensor.new_ones](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.new_ones.html) | 一致 |
| [torch.Tensor.new_zeros](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.new_zeros) | [mindspore.Tensor.new_zeros](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.new_zeros.html) | 一致 |
| [torch.Tensor.nextafter](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.nextafter) | [mindspore.Tensor.nextafter](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.nextafter.html) | 一致 |
| [torch.Tensor.norm](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.norm) | [mindspore.Tensor.norm](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.norm.html) | torch.Tensor.norm即将弃用，mindspore.Tensor.norm对标torch.linalg.norm，功能完全一致 |
| [torch.Tensor.nonzero](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.nonzero)                   | [mindspore.Tensor.nonzero](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.nonzero.html)                 | 一致 |
| [torch.Tensor.not_equal](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.not_equal)                   | [mindspore.Tensor.not_equal](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.not_equal.html)                 | 一致                                       |
| [torch.Tensor.numel](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.numel)                   | [mindspore.Tensor.numel](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.numel.html)                 | 一致                                       |
| [torch.Tensor.numpy](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.numpy) | [mindspore.Tensor.asnumpy](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.asnumpy.html) | 一致 |
| [torch.Tensor.permute](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.permute)                   | [mindspore.Tensor.permute](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.permute.html)                 | 一致                                       |
| [torch.Tensor.pow](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.pow)                       | [mindspore.Tensor.pow](https://mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.pow.html)                                        | 功能一致，参数名不同|
| [torch.Tensor.prod](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.prod)                       | [mindspore.Tensor.prod](https://mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.prod.html)                                        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/prod.html) |
| [torch.Tensor.qr](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.qr) | [mindspore.Tensor.qr](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.qr.html) | 一致 |
| [torch.Tensor.ravel](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.ravel) | [mindspore.Tensor.ravel](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.ravel.html) | 一致 |
| [torch.Tensor.real](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.real) | [mindspore.Tensor.real](https://www.mindspore.cn/docs/en/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.real.html) | 一致 |
| [torch.Tensor.reciprocal](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.reciprocal) | [mindspore.Tensor.reciprocal](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.reciprocal.html) | 一致 |
| [torch.Tensor.remainder](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.remainder)                   | [mindspore.Tensor.remainder](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.remainder.html)                 | 一致                                       |
| [torch.Tensor.renorm](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.renorm) | [mindspore.Tensor.renorm](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.renorm.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/renorm.html) |
| [torch.Tensor.rad2deg](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.rad2deg)                     | [mindspore.Tensor.rad2deg](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.rad2deg.html)                     | 一致                                       |
| [torch.Tensor.repeat](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.repeat) | [mindspore.Tensor.tile](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.tile.html) | 功能一致，参数名不同 |
| [torch.Tensor.repeat_interleave](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.repeat_interleave) | [mindspore.Tensor.repeat_interleave](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.repeat_interleave.html) | 一致                                       |
| [torch.Tensor.reshape](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.reshape)               | [mindspore.Tensor.reshape](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.reshape.html)               | 一致 |
| [torch.Tensor.reshape_as](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.reshape_as)               | [mindspore.Tensor.reshape_as](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.reshape_as.html)               | 一致                                       |
| [torch.Tensor.round](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.round)| [mindspore.Tensor.round](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.round.html)|一致|
| [torch.Tensor.rot90](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.rot90)                         | [mindspore.Tensor.rot90](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.rot90.html)                         | 一致                                       |
| [torch.Tensor.rsqrt](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.rsqrt)                           | [mindspore.Tensor.rsqrt](https://www.mindspore.cn/docs/en/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.rsqrt.html)                           |一致 |
| [torch.Tensor.scatter_](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.scatter_)                        | [mindspore.ops.tensor_scatter_elements](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.tensor_scatter_elements.html)                    |[差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/tensor_scatter_elements.html)   |
| [torch.Tensor.sum_to_size](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sum_to_size) | [mindspore.Tensor.sum_to_size](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.sum_to_size.html)                  | 一致|
| [torch.Tensor.scatter](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.scatter) | [mindspore.Tensor.scatter](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.scatter.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/scatter.html) |
| [torch.Tensor.sgn](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sgn)                           | [mindspore.Tensor.sgn](https://www.mindspore.cn/docs/en/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.sgn.html)                           |一致 |
| [torch.Tensor.short](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.short)                         | [mindspore.Tensor.short](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.short.html)                         | 一致 |
| [torch.Tensor.sigmoid](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sigmoid)               | [mindspore.Tensor.sigmoid](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.sigmoid.html)       | 一致|
| [torch.Tensor.sign](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sign)                           | [mindspore.Tensor.sign](https://www.mindspore.cn/docs/en/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.sign.html)                           |一致 |
| [torch.Tensor.signbit](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.signbit)                           | [mindspore.Tensor.signbit](https://www.mindspore.cn/docs/en/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.signbit.html)                           |一致 |
| [torch.Tensor.sin](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sin)| [mindspore.Tensor.sin](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.sin.html)|一致|
| [torch.Tensor.sinc](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sinc)| [mindspore.Tensor.sinc](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.sinc.html)|一致|
| [torch.Tensor.sinh](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sinh)| [mindspore.Tensor.sinh](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.sinh.html)|一致|
| [torch.Tensor.size](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.size)                     | [mindspore.Tensor.shape](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.shape.html#mindspore.Tensor.shape)                      | 一致 |
| [torch.Tensor.slogdet](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.slogdet)           | [mindspore.Tensor.slogdet](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.slogdet.html)           | 一致|
| [torch.Tensor.sort](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sort)           | [mindspore.Tensor.sort](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.sort.html)           | 一致 |
| [torch.Tensor.split](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.split)                         | [mindspore.Tensor.split](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.split.html)                         | 功能一致，参数名不同|
| [torch.Tensor.sqrt](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sqrt) | [mindspore.Tensor.sqrt](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.sqrt.html) | 一致 |
| [torch.Tensor.square](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.square)| [mindspore.Tensor.square](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.square.html)|一致|
| [torch.Tensor.squeeze](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.squeeze)               | [mindspore.Tensor.squeeze](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.squeeze.html) | 一致 |
| [torch.Tensor.std](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.std) | [mindspore.Tensor.std](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.std.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/std.html) |
| [torch.Tensor.sub](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.sub) | [mindspore.Tensor.subtract](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.subtract.html)                  | 一致|
| [torch.Tensor.subtract](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.subtract) | [mindspore.Tensor.subtract](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.subtract.html)                  | 一致|
| [torch.Tensor.svd](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.svd) | [mindspore.Tensor.svd](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.svd.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/svd.html) |
| [torch.Tensor.swapaxes](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.swapaxes) | [mindspore.Tensor.swapaxes](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.swapaxes.html) | 一致 |
| [torch.Tensor.swapdims](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.swapdims) | [mindspore.Tensor.swapdims](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.swapdims.html) | 一致 |
| [torch.Tensor.T](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.T)                           | [mindspore.Tensor.T](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.T.html)                       | 一致 |
| [torch.Tensor.t](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.t)                           | [mindspore.Tensor.t](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.t.html)                       | 一致 |
| [torch.Tensor.take](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.take)                           | [mindspore.Tensor.take](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.take.html)                       | 一致 |
| [torch.Tensor.tan](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.tan)| [mindspore.Tensor.tan](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.tan.html)|一致|
| [torch.Tensor.tanh](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.tanh) | [mindspore.Tensor.tanh](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.tanh.html) | 一致 |
| [torch.Tensor.trace](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.trace) | [mindspore.Tensor.trace](https://mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.trace.html) | 一致 |
| [torch.Tensor.transpose](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.transpose) | [mindspore.Tensor.swapaxes](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.swapaxes.html) | 一致 |
| [torch.Tensor.tile](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.tile) | [mindspore.Tensor.tile](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.tile.html) | 功能一致，参数名不同 |
| [torch.Tensor.to](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.to)| [mindspore.Tensor.to](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.to.html)| 功能一致，参数名不同|
| [torch.Tensor.topk](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.topk)| [mindspore.Tensor.topk](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.topk.html)|一致|
| [torch.Tensor.tril](https://pytorch.org/docs/1.8.1/tensors.html?highlight=tril#torch.Tensor.tril)           | [mindspore.Tensor.tril](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.tril.html)           | 功能一致，参数名不同|
| [torch.Tensor.tensor_split](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.tensor_split)           | [mindspore.Tensor.tensor_split](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.tensor_split.html)           | 一致|
| [torch.Tensor.true_divide](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.true_divide) | [mindspore.Tensor.true_divide](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.true_divide.html) |  一致|
| [torch.Tensor.trunc](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.trunc) | [mindspore.Tensor.trunc](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.trunc.html) |  一致|
| [torch.Tensor.unbind](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.unbind)                       | [mindspore.Tensor.unbind](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.unbind.html)                       | 一致|
| [torch.Tensor.unique_consecutive](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.unique_consecutive)                       | [mindspore.Tensor.unique_consecutive](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.unique_consecutive.html)                       | 一致 |
| [torch.Tensor.unsqueeze](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.unsqueeze)                 | [mindspore.Tensor.unsqueeze](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.unsqueeze.html)                 | 一致|
| [torch.Tensor.var](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.var) | [mindspore.Tensor.var](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.var.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/var.html) |
| [torch.Tensor.view](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.view) | [mindspore.Tensor.view](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.view.html) | 一致 |
| [torch.Tensor.view_as](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.view_as) | [mindspore.Tensor.view_as](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.view_as.html) | 一致 |
| [torch.Tensor.where](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.where) | [mindspore.Tensor.where](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.where.html) | 一致 |
| [torch.Tensor.xlogy](https://pytorch.org/docs/1.8.1/tensors.html#torch.Tensor.xlogy)                 | [mindspore.Tensor.xlogy](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/mindspore/Tensor/mindspore.Tensor.xlogy.html)                 | 功能一致，参数名不同|

### torch.optim

| PyTorch 1.8.1 APIs                                                                                                                                     | MindSpore APIs                                                                                                                                                            | 说明                                                                                                                     |
| ------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------ |
| [torch.optim.lr_scheduler.CosineAnnealingLR](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.CosineAnnealingLR) | [mindspore.nn.cosine_decay_lr](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.cosine_decay_lr.html#mindspore.nn.cosine_decay_lr)                                            | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/CosineDecayLr.html)             |
| [torch.optim.lr_scheduler.ExponentialLR](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.ExponentialLR)                             | [mindspore.nn.exponential_decay_lr](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.exponential_decay_lr.html#mindspore.nn.exponential_decay_lr)    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/ExponentialDecayLR.html)  |
| [torch.optim.lr_scheduler.MultiStepLR](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.MultiStepLR)                                 | [mindspore.nn.piecewise_constant_lr](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.piecewise_constant_lr.html#mindspore.nn.piecewise_constant_lr) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/PiecewiseConstantLR.html) |
| [torch.optim.lr_scheduler.StepLR](https://pytorch.org/docs/1.8.1/optim.html#torch.optim.lr_scheduler.StepLR)                                           | [mindspore.nn.piecewise_constant_lr](https://mindspore.cn/docs/zh-CN/r2.0/api_python/nn/mindspore.nn.piecewise_constant_lr.html#mindspore.nn.piecewise_constant_lr) |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/PiecewiseConstantLR.html) |

### torch.utils

| PyTorch 1.8.1 APIs                                                                                                                          | MindSpore APIs                                                                                                                                                                                | 说明                                                                                                                  |
| ------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------- |
| [torch.utils.data.DataLoader](https://pytorch.org/docs/1.8.1/data.html#torch.utils.data.DataLoader)                                         | None                                                                                                                                                                                          | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/DataLoader.html)       |
| [torch.utils.data.Dataset](https://pytorch.org/docs/1.8.1/data.html#torch.utils.data.Dataset)                                               | [mindspore.dataset.GeneratorDataset](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset/mindspore.dataset.GeneratorDataset.html#mindspore.dataset.GeneratorDataset)                | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/GeneratorDataset.html) |
| [torch.utils.data.distributed.DistributedSampler](https://pytorch.org/docs/1.8.1/data.html#torch.utils.data.distributed.DistributedSampler) | [mindspore.dataset.DistributedSampler](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset/mindspore.dataset.DistributedSampler.html#mindspore.dataset.DistributedSampler)          |                                                                                                                       |
| [torch.utils.data.RandomSampler](https://pytorch.org/docs/1.8.1/data.html#torch.utils.data.RandomSampler)                                   | [mindspore.dataset.RandomSampler](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset/mindspore.dataset.RandomSampler.html#mindspore.dataset.RandomSampler)                         |                                                                                                                       |
| [torch.utils.data.SequentialSampler](https://pytorch.org/docs/1.8.1/data.html#torch.utils.data.SequentialSampler)                           | [mindspore.dataset.SequentialSampler](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset/mindspore.dataset.SequentialSampler.html#mindspore.dataset.SequentialSampler)             |                                                                                                                       |
| [torch.utils.data.SubsetRandomSampler](https://pytorch.org/docs/1.8.1/data.html#torch.utils.data.SubsetRandomSampler)                       | [mindspore.dataset.SubsetRandomSampler](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset/mindspore.dataset.SubsetRandomSampler.html#mindspore.dataset.SubsetRandomSampler)       |                                                                                                                       |
| [torch.utils.data.WeightedRandomSampler](https://pytorch.org/docs/1.8.1/data.html#torch.utils.data.WeightedRandomSampler)                   | [mindspore.dataset.WeightedRandomSampler](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset/mindspore.dataset.WeightedRandomSampler.html#mindspore.dataset.WeightedRandomSampler) |                                                                                                                       |

## torchtext

| TorchText 0.10.0 APIs                                                                                                                                 | MindSpore APIs                                                                                                                                                                                                                                        | 说明                                                                                                                                   |
| ----------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------- |
| [torchtext.data.functional.custom_replace](https://pytorch.org/text/0.10.0/data_functional.html#custom-replace)                                       | [mindspore.dataset.text.RegexReplace](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_text/mindspore.dataset.text.RegexReplace.html#mindspore.dataset.text.RegexReplace)                               |                                                                                                                                        |
| [torchtext.data.functional.load_sp_model](https://pytorch.org/text/0.10.0/data_functional.html#load-sp-model)                                         | [mindspore.dataset.text.SentencePieceVocab](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_text/mindspore.dataset.text.SentencePieceVocab.html#mindspore.dataset.text.SentencePieceVocab)                               | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/SentencePieceVocab.html)                |
| [torchtext.data.functional.numericalize_tokens_from_iterator](https://pytorch.org/text/0.10.0/data_functional.html#numericalize-tokens-from-iterator) | [mindspore.dataset.text.Lookup](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_text/mindspore.dataset.text.Lookup.html#mindspore.dataset.text.Lookup)                                                 | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/Lookup.html)                            |
| [torchtext.data.functional.sentencepiece_numericalizer](https://pytorch.org/text/0.10.0/data_functional.html#sentencepiece-numericalizer)             | [mindspore.dataset.text.SentencePieceTokenizer](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_text/mindspore.dataset.text.SentencePieceTokenizer.html#mindspore.dataset.text.SentencePieceTokenizer) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/SentencePieceTokenizer_Out_INT.html)    |
| [torchtext.data.functional.sentencepiece_tokenizer](https://pytorch.org/text/0.10.0/data_functional.html#sentencepiece-tokenizer)                     | [mindspore.dataset.text.SentencePieceTokenizer](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_text/mindspore.dataset.text.SentencePieceTokenizer.html#mindspore.dataset.text.SentencePieceTokenizer) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/SentencePieceTokenizer_Out_STRING.html) |
| [torchtext.data.functional.simple_space_split](https://pytorch.org/text/0.10.0/data_functional.html#simple-space-split)                               | [mindspore.dataset.text.WhitespaceTokenizer](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_text/mindspore.dataset.text.WhitespaceTokenizer.html#mindspore.dataset.text.WhitespaceTokenizer)          |                                                                                                                                        |
| [torchtext.data.utils.ngrams_iterator](https://pytorch.org/text/0.10.0/data_utils.html#ngrams-iterator)                                               | [mindspore.dataset.text.Ngram](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_text/mindspore.dataset.text.Ngram.html#mindspore.dataset.text.Ngram)                                                    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/Ngram.html)                             |

## torchvision

| TorchVision 0.10.0 APIs                                                                                                                    | MindSpore APIs                                                                                                                                                                                                                                                   | 说明                                                                                                                 |
| ------------------------------------------------------------------------------------------------------------------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------- |
| [torchvision.datasets.CelebA](https://pytorch.org/vision/0.10/datasets.html#torchvision.datasets.CelebA)                                   | [mindspore.dataset.CelebADataset](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset/mindspore.dataset.CelebADataset.html#mindspore.dataset.CelebADataset)                                                                                            |                                                                                                                      |
| [torchvision.datasets.CIFAR10](https://pytorch.org/vision/0.10/datasets.html#torchvision.datasets.CIFAR10)                                 | [mindspore.dataset.Cifar10Dataset](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset/mindspore.dataset.Cifar10Dataset.html#mindspore.dataset.Cifar10Dataset)                                                                                         |                                                                                                                      |
| [torchvision.datasets.CIFAR100](https://pytorch.org/vision/0.10/datasets.html#torchvision.datasets.CIFAR100)                               | [mindspore.dataset.Cifar100Dataset](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset/mindspore.dataset.Cifar100Dataset.html#mindspore.dataset.Cifar100Dataset)                                                                                      |                                                                                                                      |
| [torchvision.datasets.CocoDetection](https://pytorch.org/vision/0.10/datasets.html#torchvision.datasets.CocoDetection)                     | [mindspore.dataset.CocoDataset](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset/mindspore.dataset.CocoDataset.html#mindspore.dataset.CocoDataset)                                                                                                  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/CocoDataset.html)     |
| [torchvision.datasets.ImageFolder](https://pytorch.org/vision/0.10/datasets.html#torchvision.datasets.ImageFolder)                         | [mindspore.dataset.ImageFolderDataset](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset/mindspore.dataset.ImageFolderDataset.html#mindspore.dataset.ImageFolderDataset)                                                                             |                                                                                                                      |
| [torchvision.datasets.MNIST](https://pytorch.org/vision/0.10/datasets.html#torchvision.datasets.MNIST)                                     | [mindspore.dataset.MnistDataset](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset/mindspore.dataset.MnistDataset.html#mindspore.dataset.MnistDataset)                                                                                               |                                                                                                                      |
| [torchvision.datasets.VOCDetection](https://pytorch.org/vision/0.10/datasets.html#torchvision.datasets.VOCDetection)                       | [mindspore.dataset.VOCDataset](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset/mindspore.dataset.VOCDataset.html#mindspore.dataset.VOCDataset)                                                                                                     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/VOCDetection.html)    |
| [torchvision.datasets.VOCSegmentation](https://pytorch.org/vision/0.10/datasets.html#torchvision.datasets.VOCSegmentation)                 | [mindspore.dataset.VOCDataset](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset/mindspore.dataset.VOCDataset.html#mindspore.dataset.VOCDataset)                                                                                                     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/VOCSegmentation.html) |
| [torchvision.ops.nms](https://pytorch.org/vision/0.10/ops.html#torchvision.ops.nms)                                                        | [mindspore.ops.NMSWithMask](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.NMSWithMask.html#mindspore.ops.NMSWithMask)                                                                                                                  |                                                                                                                      |
| [torchvision.ops.roi_align](https://pytorch.org/vision/0.10/ops.html#torchvision.ops.roi_align)                                            | [mindspore.ops.ROIAlign](https://mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.ROIAlign.html#mindspore.ops.ROIAlign)                                                                                                                           |                                                                                                                      |
| [torchvision.transforms.CenterCrop](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.CenterCrop)                     | [mindspore.dataset.vision.CenterCrop](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.CenterCrop.html#mindspore.dataset.vision.CenterCrop)                                  |                                                                                                                      |
| [torchvision.transforms.ColorJitter](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.ColorJitter)                   | [mindspore.dataset.vision.RandomColorAdjust](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.RandomColorAdjust.html#mindspore.dataset.vision.RandomColorAdjust)             |                                                                                                                      |
| [torchvision.transforms.Compose](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.Compose)                           | [mindspore.dataset.transforms.Compose](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_transforms/mindspore.dataset.transforms.Compose.html#mindspore.dataset.transforms.Compose)                           |                                                                                                                      |
| [torchvision.transforms.ConvertImageDtype](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.ConvertImageDtype)       | [mindspore.dataset.transforms.TypeCast](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_transforms/mindspore.dataset.transforms.TypeCast.html#mindspore.dataset.transforms.TypeCast)                                           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/TypeCast.html)          |
| [torchvision.transforms.FiveCrop](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.FiveCrop)                         | [mindspore.dataset.vision.FiveCrop](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.FiveCrop.html#mindspore.dataset.vision.FiveCrop)                                     |                                                                                                                      |
| [torchvision.transforms.GaussianBlur](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.GaussianBlur)                 | [mindspore.dataset.vision.GaussianBlur](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.GaussianBlur.html#mindspore.dataset.vision.GaussianBlur)                            |                                                                                                                      |
| [torchvision.transforms.Grayscale](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.Grayscale)                       | [mindspore.dataset.vision.Grayscale](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.Grayscale.html#mindspore.dataset.vision.Grayscale)                                  |                                                                                                                      |
| [torchvision.transforms.LinearTransformation](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.LinearTransformation) | [mindspore.dataset.vision.LinearTransformation](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.LinearTransformation.html#mindspore.dataset.vision.LinearTransformation) |                                                                                                                      |
| [torchvision.transforms.Normalize](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.Normalize)                       | [mindspore.dataset.vision.Normalize](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.Normalize.html#mindspore.dataset.vision.Normalize)                                     |                                                                                                                      |
| [torchvision.transforms.Pad](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.Pad)                                   | [mindspore.dataset.vision.Pad](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.Pad.html#mindspore.dataset.vision.Pad)                                                       |                                                                                                                      |
| [torchvision.transforms.RandomAffine](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomAffine)                 | [mindspore.dataset.vision.RandomAffine](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.RandomAffine.html#mindspore.dataset.vision.RandomAffine)                            |                                                                                                                      |
| [torchvision.transforms.RandomApply](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomApply)                   | [mindspore.dataset.transforms.RandomApply](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_transforms/mindspore.dataset.transforms.RandomApply.html#mindspore.dataset.transforms.RandomApply)               |                                                                                                                      |
| [torchvision.transforms.RandomChoice](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomChoice)                 | [mindspore.dataset.transforms.RandomChoice](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_transforms/mindspore.dataset.transforms.RandomChoice.html#mindspore.dataset.transforms.RandomChoice)            |                                                                                                                      |
| [torchvision.transforms.RandomCrop](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomCrop)                     | [mindspore.dataset.vision.RandomCrop](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.RandomCrop.html#mindspore.dataset.vision.RandomCrop)                                  |                                                                                                                      |
| [torchvision.transforms.RandomErasing](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomErasing)               | [mindspore.dataset.vision.RandomErasing](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.RandomErasing.html#mindspore.dataset.vision.RandomErasing)                      |                                                                                                                      |
| [torchvision.transforms.RandomGrayscale](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomGrayscale)           | [mindspore.dataset.vision.RandomGrayscale](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.RandomGrayscale.html#mindspore.dataset.vision.RandomGrayscale)                |                                                                                                                      |
| [torchvision.transforms.RandomHorizontalFlip](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomHorizontalFlip) | [mindspore.dataset.vision.RandomHorizontalFlip](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.RandomHorizontalFlip.html#mindspore.dataset.vision.RandomHorizontalFlip)    |                                                                                                                      |
| [torchvision.transforms.RandomOrder](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomOrder)                   | [mindspore.dataset.transforms.RandomOrder](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_transforms/mindspore.dataset.transforms.RandomOrder.html#mindspore.dataset.transforms.RandomOrder)            |                                                                                                                      |
| [torchvision.transforms.RandomPerspective](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomPerspective)       | [mindspore.dataset.vision.RandomPerspective](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.RandomPerspective.html#mindspore.dataset.vision.RandomPerspective)          |                                                                                                                      |
| [torchvision.transforms.RandomPosterize](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomPosterize)           | [mindspore.dataset.vision.RandomPosterize](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.RandomPosterize.html#mindspore.dataset.vision.RandomPosterize)                   |                                                                                                                      |
| [torchvision.transforms.RandomResizedCrop](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomResizedCrop)       | [mindspore.dataset.vision.RandomResizedCrop](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.RandomResizedCrop.html#mindspore.dataset.vision.RandomResizedCrop)             |                                                                                                                      |
| [torchvision.transforms.RandomRotation](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomRotation)             | [mindspore.dataset.vision.RandomRotation](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.RandomRotation.html#mindspore.dataset.vision.RandomRotation)                      |                                                                                                                      |
| [torchvision.transforms.RandomSolarize](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomSolarize)             | [mindspore.dataset.vision.RandomSolarize](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.RandomSolarize.html#mindspore.dataset.vision.RandomSolarize)                      | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/RandomSolarize.html)  |
| [torchvision.transforms.RandomVerticalFlip](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomVerticalFlip)     | [mindspore.dataset.vision.RandomVerticalFlip](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.RandomVerticalFlip.html#mindspore.dataset.vision.RandomVerticalFlip)          |                                                                                                                      |
| [torchvision.transforms.Resize](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.Resize)                             | [mindspore.dataset.vision.Resize](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.Resize.html#mindspore.dataset.vision.Resize)                                              |                                                                                                                      |
| [torchvision.transforms.TenCrop](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.TenCrop)                           | [mindspore.dataset.vision.TenCrop](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.TenCrop.html#mindspore.dataset.vision.TenCrop)                                        |                                                                                                                      |
| [torchvision.transforms.ToPILImage](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.ToPILImage)                     | [mindspore.dataset.vision.ToPIL](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.ToPIL.html#mindspore.dataset.vision.ToPIL)                                              | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/ToPIL.html)           |
| [torchvision.transforms.ToTensor](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.ToTensor)                         | [mindspore.dataset.vision.ToTensor](https://mindspore.cn/docs/zh-CN/r2.0/api_python/dataset_vision/mindspore.dataset.vision.ToTensor.html#mindspore.dataset.vision.ToTensor)                                     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/ToTensor.html)        |

| TorchVision 0.14.0 APIs                                                                                                                    | MindSpore APIs                                                                                                                                                                                                                                                   | 说明                                                                                                                 |
| ------------------------------------------------------------------------------------------------------------------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------- |
| [torchvision.ops.deform_conv2d](https://pytorch.org/vision/0.14/generated/torchvision.ops.deform_conv2d.html#deform-conv2d) | [mindspore.ops.deformable_conv2d](https://www.mindspore.cn/docs/zh-CN/r2.0/api_python/ops/mindspore.ops.deformable_conv2d.html#mindspore-ops-deformable-conv2d) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r2.0/note/api_mapping/pytorch_diff/deform_conv2d.html)        |
