/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.statusbar;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.mindspore.ide.toolkit.smartcomplete.CompleteConfig;
import com.mindspore.ide.toolkit.statusbar.service.MindSporeStatusBarServiceImpl;
import com.mindspore.ide.toolkit.statusbar.utils.MindSporeVersionUtils;
import icons.MsIcons;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MindSporeStatusBarWidget
extends EditorBasedStatusBarPopup {
    private static final Logger log = LoggerFactory.getLogger(MindSporeStatusBarWidget.class);
    private static final String WIDGET_ID = "com.mindspore.widget";

    public MindSporeStatusBarWidget(@NotNull Project project) {
        if (project == null) {
            MindSporeStatusBarWidget.$$$reportNull$$$0(0);
        }
        super(project, false);
    }

    @NonNls
    @NotNull
    public String ID() {
        return WIDGET_ID;
    }

    public static void update(@NotNull Project project) {
        MindSporeStatusBarWidget widget;
        if (project == null) {
            MindSporeStatusBarWidget.$$$reportNull$$$0(1);
        }
        if ((widget = MindSporeStatusBarWidget.findWidget(project)) != null) {
            widget.update(() -> widget.myStatusBar.updateWidget(WIDGET_ID));
        }
    }

    @Nullable
    private static MindSporeStatusBarWidget findWidget(@NotNull Project project) {
        StatusBarWidget widget;
        StatusBar bar;
        if (project == null) {
            MindSporeStatusBarWidget.$$$reportNull$$$0(2);
        }
        if ((bar = WindowManager.getInstance().getStatusBar(project)) != null && (widget = bar.getWidget(WIDGET_ID)) instanceof MindSporeStatusBarWidget) {
            return (MindSporeStatusBarWidget)widget;
        }
        return null;
    }

    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file) {
        String version = MindSporeStatusBarServiceImpl.getCurrentSelectedVersion();
        if (StringUtils.isEmpty((String)version)) {
            version = MindSporeVersionUtils.getBigVersion(CompleteConfig.PLUGIN_VERSION);
            MindSporeStatusBarServiceImpl.setCurrentSelectedVersion(version);
            MindSporeVersionUtils.initVersionMap(version);
        }
        EditorBasedStatusBarPopup.WidgetState state = new EditorBasedStatusBarPopup.WidgetState("", "mindspore " + version, true);
        state.setIcon(MsIcons.MS_ICON_12PX);
        EditorBasedStatusBarPopup.WidgetState widgetState = state;
        if (widgetState == null) {
            MindSporeStatusBarWidget.$$$reportNull$$$0(3);
        }
        return widgetState;
    }

    @Nullable
    protected ListPopup createPopup(DataContext context) {
        DefaultActionGroup group = MindSporeStatusBarServiceImpl.createVersionActionsGroup();
        DefaultActionGroup popupGroup = new DefaultActionGroup();
        AnAction action = ActionManager.getInstance().getAction("otherVersion");
        if (action != null) {
            popupGroup.add(action);
            popupGroup.addSeparator();
        }
        popupGroup.add((AnAction)group);
        return JBPopupFactory.getInstance().createActionGroupPopup("Api Mapping", (ActionGroup)popupGroup, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
    }

    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project) {
        if (project == null) {
            MindSporeStatusBarWidget.$$$reportNull$$$0(4);
        }
        return new MindSporeStatusBarWidget(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/mindspore/ide/toolkit/statusbar/MindSporeStatusBarWidget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/mindspore/ide/toolkit/statusbar/MindSporeStatusBarWidget";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findWidget";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

