/**
 * Copyright 2023 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef NNACL_KERNEL_SCALE_H_
#define NNACL_KERNEL_SCALE_H_

#include "nnacl_c/op_base.h"
#include "nnacl_c/tensor_c.h"
#include "nnacl_c/kernel.h"

typedef struct ScaleStruct {
  KernelBase base_;
  int axis_;
  int data_type_;
  int axis_size_;
  int outer_size_;
  int inner_size_;
  bool malloc_scale_;
  bool malloc_offset_;
  void *scale_;
  void *offset_;
  void *input_;
  void *output_;
} ScaleStruct;

KernelBase *CreateScale(OpParameter *param, int data_type);

#endif  // NNACL_KERNEL_SCALE_H_
